/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import dev.sapphic.armorsoundtweak.ArmorSoundTweak;
import dev.sapphic.armorsoundtweak.EquipmentConfig;
import dev.sapphic.armorsoundtweak.EquipmentTicker;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraftforge.common.MinecraftForge;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ArmorTicker
extends EquipmentTicker {
    private final EquipmentConfig.Sounds sounds = ArmorSoundTweak.config().sounds();

    ArmorTicker() {
    }

    static void register() {
        MinecraftForge.EVENT_BUS.addListener((Consumer)new ArmorTicker());
    }

    private static boolean isSkull(Item item) {
        return item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock;
    }

    @Override
    protected Iterable<ItemStack> getEquipment(Player player) {
        ArrayList<ItemStack> equipment = new ArrayList<ItemStack>(4);
        for (ItemStack stack : player.m_6168_()) {
            equipment.add(stack.m_41777_());
        }
        return equipment;
    }

    @Override
    protected void playEquipSound(Player player, Item item) {
        if (!ArmorSoundTweak.config().allowsArmor()) {
            return;
        }
        @Nullable SoundEvent sound = this.getEquipSound(item);
        if (sound != null) {
            player.m_6330_(sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private @Nullable SoundEvent getEquipSound(Item item) {
        if (this.sounds.hasArmor() && item instanceof ArmorItem) {
            return ((ArmorItem)item).m_40401_().m_7344_();
        }
        if (this.sounds.hasElytra() && item instanceof ElytraItem) {
            return SoundEvents.f_11674_;
        }
        if (this.sounds.hasPumpkins() && item == Items.f_42047_) {
            return SoundEvents.f_11675_;
        }
        if (this.sounds.hasSkulls() && ArmorTicker.isSkull(item)) {
            return SoundEvents.f_11675_;
        }
        if (this.sounds.hasAnything()) {
            return SoundEvents.f_11675_;
        }
        return null;
    }
}

