/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.PuzzlesLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StringEntryReader<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> activeRegistry;

    protected StringEntryReader(IForgeRegistry<T> registry) {
        this.activeRegistry = registry;
    }

    protected final List<T> getEntriesFromRegistry(String source) {
        return StringEntryReader.getEntriesFromRegistry(source, this.activeRegistry);
    }

    public static <R extends IForgeRegistryEntry<R>> List<R> getEntriesFromRegistry(String source, IForgeRegistry<R> activeRegistry) {
        ArrayList foundEntries = Lists.newArrayList();
        if (source.contains("*")) {
            foundEntries.addAll(StringEntryReader.getWildcardEntries(source, activeRegistry));
        } else {
            Optional<ResourceLocation> location = Optional.ofNullable(ResourceLocation.m_135820_((String)source));
            if (location.isPresent()) {
                Optional<R> entry = StringEntryReader.getEntryFromRegistry(location.get(), activeRegistry);
                entry.ifPresent(foundEntries::add);
            } else {
                StringEntryReader.log(source, "Entry not found");
            }
        }
        return foundEntries;
    }

    private static <R extends IForgeRegistryEntry<R>> Optional<R> getEntryFromRegistry(ResourceLocation location, IForgeRegistry<R> activeRegistry) {
        if (activeRegistry.containsKey(location)) {
            return Optional.ofNullable(activeRegistry.getValue(location));
        }
        StringEntryReader.log(location.toString(), "Entry not found");
        return Optional.empty();
    }

    private static <R extends IForgeRegistryEntry<R>> List<R> getWildcardEntries(String source, IForgeRegistry<R> activeRegistry) {
        if (!((String)source).contains(":")) {
            source = "minecraft:" + (String)source;
        }
        String regexSource = ((String)source).replace("*", "[a-z0-9/._-]*");
        List entries = activeRegistry.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().toString().matches(regexSource)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (entries.isEmpty()) {
            StringEntryReader.log((String)source, "Entry not found");
        }
        return entries;
    }

    protected final boolean isNotPresent(Collection<T> collection, T entry) {
        if (collection.contains(entry)) {
            StringEntryReader.log(entry.getRegistryName().toString(), "Already present");
            return false;
        }
        return true;
    }

    protected static void log(String entry, String message) {
        PuzzlesLib.LOGGER.warn("Unable to parse entry {}: {}", (Object)entry, (Object)message);
    }
}

