/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.mixin;

import com.gitlab.qolq.powershot.Powerable;
import com.gitlab.qolq.powershot.Powershot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity
implements Powerable {
    @Unique
    private static final String POWER_KEY = "powershot:power";
    @Unique
    private float power = 0.0f;

    public AbstractArrowMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    @Unique
    public float powershot$getPower() {
        return this.power;
    }

    @Override
    @Unique
    public void powershot$setPower(float power) {
        this.power = power;
    }

    @Inject(method={"shoot(DDDFF)V"}, at={@At(value="HEAD")})
    private void setPower(double x, double y, double z, float speed, float inaccuracy, CallbackInfo info) {
        if (!this.f_19853_.f_46443_) {
            this.powershot$setPower(Powershot.calculatePower((AbstractArrow)this, speed));
        }
    }

    @Redirect(method={"tick()V"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;inGroundTime:I", opcode=181, ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getLocation()Lnet/minecraft/world/phys/Vec3;")), at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;clip(Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;", ordinal=0))
    private BlockHitResult clip(Level level, ClipContext context) {
        return Powershot.clip(level, context, (AbstractArrow)this);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void writeData(CompoundTag tag, CallbackInfo info) {
        tag.m_128350_(POWER_KEY, this.powershot$getPower());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void readData(CompoundTag tag, CallbackInfo info) {
        this.powershot$setPower(tag.m_128457_(POWER_KEY));
    }
}

