/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.powercalc.v2;

import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.config.powercalc.PowerCalculationConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.ForgeRegistries;

public final class SchemaV2 {
    private static final String BASE_POWER_KEY = "base_power";
    private static final String ENCHANTMENT_MULTIPLIERS_KEY = "enchantment_multipliers";

    public static PowerCalculationConfig read(JsonObject json) {
        float basePower = 1.0f;
        Object2FloatMap<ResourceLocation> enchantmentToMultiplier = Object2FloatMaps.emptyMap();
        for (Map.Entry entry : json.entrySet()) {
            try {
                switch ((String)entry.getKey()) {
                    case "schema_version": {
                        break;
                    }
                    case "base_power": {
                        basePower = GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)BASE_POWER_KEY);
                        break;
                    }
                    case "enchantment_multipliers": {
                        enchantmentToMultiplier = SchemaV2.readEnchantmentMultipliers(GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)ENCHANTMENT_MULTIPLIERS_KEY));
                        break;
                    }
                    default: {
                        Powershot.log.debug("Ignoring unrecognized power calculation config property: {}", entry.getKey());
                        break;
                    }
                }
            }
            catch (JsonParseException e) {
                Powershot.log.debug("Failed to read power calculation config property: " + (String)entry.getKey(), (Throwable)e);
            }
        }
        return new PowerCalculationConfig(basePower, enchantmentToMultiplier);
    }

    private static Object2FloatMap<ResourceLocation> readEnchantmentMultipliers(JsonObject json) {
        Object2FloatOpenHashMap map = new Object2FloatOpenHashMap();
        for (Map.Entry entry : json.entrySet()) {
            try {
                ResourceLocation id = new ResourceLocation((String)entry.getKey());
                if (ForgeRegistries.ENCHANTMENTS.containsKey(id)) {
                    float multiplier = GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)id.toString());
                    if (multiplier == 0.0f || !Float.isFinite(multiplier)) continue;
                    map.put((Object)id, multiplier);
                    continue;
                }
                Powershot.log.debug("Invalid enchantment multiplier entry (not a registered enchantment): '{}'", (Object)id);
            }
            catch (JsonParseException | ResourceLocationException e) {
                Powershot.log.debug("Failed to read enchantment multiplier entry: " + (String)entry.getKey(), e);
            }
        }
        return map.isEmpty() ? Object2FloatMaps.emptyMap() : map;
    }
}

