/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.powercalc.v1;

import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.config.powercalc.PowerCalculationConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class SchemaV1 {
    private static final String BASE_POWER_KEY = "base_power";
    private static final String POWER_MULTIPLIER_KEY = "power_multiplier";
    private static final String PIERCING_MULTIPLIER_KEY = "piercing_multiplier";
    private static final String PUNCH_MULTIPLIER_KEY = "punch_multiplier";
    private static final String KNOCKBACK_MULTIPLIER_KEY = "knockback_multiplier";

    public static PowerCalculationConfig read(JsonObject json) {
        float basePower = 1.0f;
        Object2FloatOpenHashMap enchantmentToMultiplier = new Object2FloatOpenHashMap();
        for (Map.Entry entry : json.entrySet()) {
            try {
                switch ((String)entry.getKey()) {
                    case "schema_version": {
                        break;
                    }
                    case "base_power": {
                        basePower = GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)BASE_POWER_KEY);
                        break;
                    }
                    case "power_multiplier": {
                        enchantmentToMultiplier.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.f_44988_), GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)POWER_MULTIPLIER_KEY));
                        break;
                    }
                    case "piercing_multiplier": {
                        enchantmentToMultiplier.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.f_44961_), GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)PIERCING_MULTIPLIER_KEY));
                        break;
                    }
                    case "punch_multiplier": {
                        enchantmentToMultiplier.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.f_44989_), GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)PUNCH_MULTIPLIER_KEY));
                        break;
                    }
                    case "knockback_multiplier": {
                        enchantmentToMultiplier.put((Object)ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.f_44980_), GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)KNOCKBACK_MULTIPLIER_KEY));
                        break;
                    }
                    default: {
                        Powershot.log.debug("Ignoring unrecognized power calculation config property: {}", entry.getKey());
                        break;
                    }
                }
            }
            catch (JsonParseException e) {
                Powershot.log.debug("Failed to read power calculation config property: " + (String)entry.getKey(), (Throwable)e);
            }
        }
        return new PowerCalculationConfig(basePower, (Object2FloatMap<ResourceLocation>)(enchantmentToMultiplier.isEmpty() ? Object2FloatMaps.emptyMap() : enchantmentToMultiplier));
    }
}

