/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.powercalc;

import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.config.powercalc.v1.SchemaV1;
import com.gitlab.qolq.powershot.config.powercalc.v2.SchemaV2;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FileUtils;

public record PowerCalculationConfig(float basePower, Object2FloatMap<ResourceLocation> enchantmentToMultiplier) {
    public static final float DEFAULT_BASE_POWER = 1.0f;
    public static final String SCHEMA_VERSION_KEY = "schema_version";
    private static final String DEFAULT_CONFIG_PATH = "/data/powershot/default_power_calculation.json";

    public PowerCalculationConfig(float basePower, Object2FloatMap<ResourceLocation> enchantmentToMultiplier) {
        this.basePower = basePower;
        this.enchantmentToMultiplier = Object2FloatMaps.unmodifiable(enchantmentToMultiplier);
    }

    public PowerCalculationConfig() {
        this(1.0f, (Object2FloatMap<ResourceLocation>)Object2FloatMaps.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PowerCalculationConfig from(File file) {
        if (!file.exists()) {
            try (InputStream stream = PowerCalculationConfig.class.getResourceAsStream(DEFAULT_CONFIG_PATH);){
                if (stream == null) {
                    Powershot.log.debug("Failed to write default power calculation config file (file not found)");
                    PowerCalculationConfig powerCalculationConfig = new PowerCalculationConfig();
                    return powerCalculationConfig;
                }
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            }
            catch (IOException e) {
                Powershot.log.warn("Failed to write default power calculation config file", (Throwable)e);
                return new PowerCalculationConfig();
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (!json.has(SCHEMA_VERSION_KEY)) {
                Powershot.log.debug("Power calculation config file has no schema version");
                PowerCalculationConfig powerCalculationConfig = SchemaV1.read(json);
                return powerCalculationConfig;
            }
            switch (GsonHelper.m_13824_((JsonObject)json, (String)SCHEMA_VERSION_KEY, (int)Integer.MAX_VALUE)) {
                case 1: {
                    Powershot.log.info("Power calculation config file is in an outdated format. Please consider updating it");
                    PowerCalculationConfig powerCalculationConfig = SchemaV1.read(json);
                    return powerCalculationConfig;
                }
                case 2: {
                    PowerCalculationConfig powerCalculationConfig = SchemaV2.read(json);
                    return powerCalculationConfig;
                }
            }
            Powershot.log.debug("Unsupported power calculation config schema version: {}", (Object)json.get(SCHEMA_VERSION_KEY));
            PowerCalculationConfig powerCalculationConfig = SchemaV2.read(json);
            return powerCalculationConfig;
        }
        catch (JsonParseException | IOException e) {
            Powershot.log.warn("Failed to read file " + file, e);
            return new PowerCalculationConfig();
        }
    }
}

