/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.breakableblocks.v1;

import com.gitlab.qolq.powershot.Powershot;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

public final class TagEntries {
    public static void read(JsonElement json, Collection<TagKey<Block>> tags) {
        if (json.isJsonArray()) {
            TagEntries.readArrayTagEntry(json.getAsJsonArray(), tags);
        } else if (json.isJsonPrimitive() && ((JsonPrimitive)json).isString()) {
            TagEntries.readStringTagEntry(json.getAsJsonPrimitive(), tags);
        } else {
            Powershot.log.debug("Invalid tags entry (was not a string nor an array): {}", (Object)json);
        }
    }

    private static void readArrayTagEntry(JsonArray json, Collection<TagKey<Block>> tags) {
        for (JsonElement jsonTag : json) {
            try {
                if (jsonTag.isJsonPrimitive() && ((JsonPrimitive)jsonTag).isString()) {
                    TagEntries.readStringTagEntry(jsonTag.getAsJsonPrimitive(), tags);
                    continue;
                }
                Powershot.log.debug("Invalid tag entry (was not a string): {}", (Object)jsonTag);
            }
            catch (JsonParseException e) {
                Powershot.log.debug("Failed to read tag entry", (Throwable)e);
            }
        }
    }

    private static void readStringTagEntry(JsonPrimitive json, Collection<TagKey<Block>> tags) {
        try {
            tags.add((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)"tag"))));
        }
        catch (ResourceLocationException e) {
            Powershot.log.debug("Invalid tag entry (invalid id): {}", (Object)json);
        }
    }
}

