/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.breakableblocks.v1;

import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.config.breakableblocks.BreakableBlocksConfig;
import com.gitlab.qolq.powershot.config.breakableblocks.v1.BlockEntries;
import com.gitlab.qolq.powershot.config.breakableblocks.v1.TagEntries;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class SchemaV1 {
    private static final String BLOCKS_KEY = "blocks";
    private static final String TAGS_KEY = "tags";
    private static final String POWER_REQ_KEY = "power_req";
    private static final String POWER_RED_KEY = "power_red";

    public static BreakableBlocksConfig read(JsonArray json) {
        HashMap<BlockState, BreakableBlocksConfig.Entry> statesToEntries = new HashMap<BlockState, BreakableBlocksConfig.Entry>();
        LinkedHashMap<TagKey<Block>, BreakableBlocksConfig.Entry> tagsToEntries = new LinkedHashMap<TagKey<Block>, BreakableBlocksConfig.Entry>();
        for (JsonElement entry : json) {
            if (entry.isJsonObject()) {
                SchemaV1.readEntry(entry.getAsJsonObject(), statesToEntries, tagsToEntries);
                continue;
            }
            Powershot.log.debug("Invalid breakable blocks entry (not an object): {}", (Object)entry);
        }
        return new BreakableBlocksConfig(statesToEntries.isEmpty() ? Collections.emptyMap() : statesToEntries, tagsToEntries.isEmpty() ? Collections.emptyMap() : tagsToEntries);
    }

    private static void readEntry(JsonObject json, Map<BlockState, BreakableBlocksConfig.Entry> statesToEntries, Map<TagKey<Block>, BreakableBlocksConfig.Entry> tagsToEntries) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        float powerRequirement = 1.5f;
        float powerReduction = 1.5f;
        for (Map.Entry entry : json.entrySet()) {
            try {
                switch ((String)entry.getKey()) {
                    case "blocks": {
                        BlockEntries.read((JsonElement)entry.getValue(), states);
                        break;
                    }
                    case "tags": {
                        TagEntries.read((JsonElement)entry.getValue(), tags);
                        break;
                    }
                    case "power_req": {
                        powerRequirement = GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)POWER_REQ_KEY);
                        break;
                    }
                    case "power_red": {
                        powerReduction = GsonHelper.m_13888_((JsonElement)((JsonElement)entry.getValue()), (String)POWER_RED_KEY);
                        break;
                    }
                    default: {
                        Powershot.log.debug("Ignoring unrecognized breakable blocks entry property: {}", entry.getKey());
                        break;
                    }
                }
            }
            catch (JsonParseException jsonParseException) {
                Powershot.log.debug("Failed to read breakable blocks entry property: " + (String)entry.getKey(), (Throwable)jsonParseException);
            }
        }
        if (states.isEmpty() && tags.isEmpty()) {
            Powershot.log.debug("Ignoring invalid breakable blocks entry (no blocks or tags specified): {}", (Object)json);
            return;
        }
        BreakableBlocksConfig.Entry entry = new BreakableBlocksConfig.Entry(powerRequirement, powerReduction);
        for (BlockState blockState : states) {
            BreakableBlocksConfig.Entry replaced = statesToEntries.put(blockState, entry);
            if (replaced == null) continue;
            Powershot.log.debug("Replaced breakable blocks block state entry: {} ({} -> {})", (Object)blockState, (Object)replaced, (Object)entry);
        }
        for (TagKey tagKey : tags) {
            BreakableBlocksConfig.Entry replaced = tagsToEntries.put((TagKey<Block>)tagKey, entry);
            if (replaced == null) continue;
            Powershot.log.debug("Replaced breakable blocks tag entry: {} ({} -> {})", (Object)tagKey, (Object)replaced, (Object)entry);
        }
    }
}

