/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.breakableblocks.v1;

import com.gitlab.qolq.powershot.Powershot;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public final class BlockEntries {
    private static final String BLOCK_ID_KEY = "id";
    private static final String BLOCK_STATES_KEY = "states";
    private static final String NORMAL_BLOCK_STATE_ENTRY = "normal";

    public static void read(JsonElement json, Collection<BlockState> states) {
        if (json.isJsonArray()) {
            BlockEntries.readArrayBlockEntry(json.getAsJsonArray(), states);
        } else if (json.isJsonObject()) {
            BlockEntries.readObjectBlockEntry(json.getAsJsonObject(), states);
        } else if (json.isJsonPrimitive() && ((JsonPrimitive)json).isString()) {
            BlockEntries.readStringBlockEntry(json.getAsJsonPrimitive(), states);
        } else {
            Powershot.log.debug("Invalid blocks entry (was not a string, an object, nor an array): {}", (Object)json);
        }
    }

    private static void readArrayBlockEntry(JsonArray json, Collection<BlockState> states) {
        for (JsonElement jsonBlock : json) {
            try {
                if (jsonBlock.isJsonObject()) {
                    BlockEntries.readObjectBlockEntry(jsonBlock.getAsJsonObject(), states);
                    continue;
                }
                if (jsonBlock.isJsonPrimitive() && ((JsonPrimitive)jsonBlock).isString()) {
                    BlockEntries.readStringBlockEntry(jsonBlock.getAsJsonPrimitive(), states);
                    continue;
                }
                Powershot.log.debug("Invalid block entry (was neither a string nor an object): {}", (Object)jsonBlock);
            }
            catch (JsonParseException e) {
                Powershot.log.debug("Failed to read block entry", (Throwable)e);
            }
        }
    }

    private static void readObjectBlockEntry(JsonObject json, Collection<BlockState> states) {
        ResourceLocation id;
        JsonElement jsonId = json.get(BLOCK_ID_KEY);
        if (jsonId == null) {
            Powershot.log.debug("Invalid block entry (no block id specified): {}", (Object)json);
            return;
        }
        try {
            id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)jsonId, (String)BLOCK_ID_KEY));
        }
        catch (ResourceLocationException e) {
            Powershot.log.debug("Invalid block entry (invalid id): {}", (Object)json);
            return;
        }
        if (!ForgeRegistries.BLOCKS.containsKey(id)) {
            Powershot.log.debug("Invalid block entry (not a registered block): {}", (Object)id);
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        JsonElement jsonStates = json.get(BLOCK_STATES_KEY);
        assert (block != null);
        if (jsonStates == null) {
            states.addAll((Collection<BlockState>)block.m_49965_().m_61056_());
        } else {
            StateDefinition definition = block.m_49965_();
            for (JsonElement jsonState : GsonHelper.m_13924_((JsonElement)jsonStates, (String)"block states entry")) {
                try {
                    String stringState = GsonHelper.m_13805_((JsonElement)jsonState, (String)"block state entry");
                    BlockState state = BlockEntries.readBlockStateEntry(stringState, (StateDefinition<Block, BlockState>)definition, id);
                    if (state == null) continue;
                    states.add(state);
                }
                catch (JsonParseException e) {
                    Powershot.log.debug("Failed to read '" + id + "' state entry: " + jsonState, (Throwable)e);
                }
            }
        }
    }

    private static void readStringBlockEntry(JsonPrimitive json, Collection<BlockState> states) {
        try {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)BLOCK_ID_KEY));
            if (ForgeRegistries.BLOCKS.containsKey(id)) {
                states.addAll((Collection<BlockState>)((Block)ForgeRegistries.BLOCKS.getValue(id)).m_49965_().m_61056_());
            } else {
                Powershot.log.debug("Invalid block entry (not a registered block): {}", (Object)id);
            }
        }
        catch (ResourceLocationException e) {
            Powershot.log.debug("Invalid block entry (invalid id): {}", (Object)json);
        }
    }

    private static <T extends Comparable<T>> BlockState readBlockStateEntry(String stringState, StateDefinition<Block, BlockState> definition, ResourceLocation blockId) {
        if (NORMAL_BLOCK_STATE_ENTRY.equals(stringState)) {
            return (BlockState)definition.m_61090_();
        }
        BlockState state = (BlockState)definition.m_61090_();
        for (String stringProperty : stringState.split(",")) {
            String[] propertyAndValueNames = stringProperty.split("=");
            if (propertyAndValueNames.length != 2) {
                Powershot.log.debug("Invalid '{}' state entry (not a property name and value pair): {}", (Object)blockId, (Object)stringProperty);
                return null;
            }
            String propertyName = propertyAndValueNames[0];
            Property property = definition.m_61081_(propertyName);
            if (property == null) {
                Powershot.log.debug("Invalid '{}' state entry (unrecognized property): {}", (Object)blockId, (Object)propertyName);
                return null;
            }
            String valueName = propertyAndValueNames[1];
            Comparable value = property.m_6215_(valueName).orElse(null);
            if (value == null) {
                Powershot.log.debug("Invalid '{}' state entry (unrecognized '{}' value): {}", (Object)blockId, (Object)propertyName, (Object)valueName);
                return null;
            }
            state = (BlockState)state.m_61124_(property, value);
        }
        return state;
    }
}

