/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot.config.breakableblocks;

import com.gitlab.qolq.powershot.Powershot;
import com.gitlab.qolq.powershot.config.breakableblocks.v1.SchemaV1;
import com.gitlab.qolq.powershot.config.breakableblocks.v2.SchemaV2;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.io.FileUtils;

public final class BreakableBlocksConfig {
    public static final String SCHEMA_VERSION_KEY = "schema_version";
    private static final String DEFAULT_CONFIG_PATH = "/data/powershot/default_breakable_blocks.json";
    private final Map<BlockState, Entry> statesToEntries;
    private final Map<TagKey<Block>, Entry> tagsToEntries;
    private volatile Map<BlockState, Entry> merged;

    public BreakableBlocksConfig(Map<BlockState, Entry> statesToEntries, Map<TagKey<Block>, Entry> tagsToEntries) {
        this.statesToEntries = Collections.unmodifiableMap(statesToEntries);
        this.tagsToEntries = Collections.unmodifiableMap(tagsToEntries);
    }

    public BreakableBlocksConfig() {
        this(Collections.emptyMap(), Collections.emptyMap());
    }

    public Entry get(BlockState key) {
        return this.merged.get(key);
    }

    public synchronized void reloadTags() {
        HashMap<BlockState, Entry> map = new HashMap<BlockState, Entry>();
        for (Map.Entry<TagKey<Block>, Entry> entry : this.tagsToEntries.entrySet()) {
            Optional tag = Registry.f_122824_.m_203431_(entry.getKey());
            if (tag.isEmpty()) continue;
            for (Holder blockHolder : (HolderSet.Named)tag.get()) {
                for (BlockState state : ((Block)blockHolder.m_203334_()).m_49965_().m_61056_()) {
                    map.put(state, entry.getValue());
                }
            }
        }
        map.putAll(this.statesToEntries);
        this.merged = Collections.unmodifiableMap(map);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BreakableBlocksConfig from(File file) {
        if (!file.exists()) {
            try (InputStream stream = BreakableBlocksConfig.class.getResourceAsStream(DEFAULT_CONFIG_PATH);){
                if (stream == null) {
                    Powershot.log.debug("Failed to write default breakable blocks config file (file not found)");
                    BreakableBlocksConfig breakableBlocksConfig = new BreakableBlocksConfig();
                    return breakableBlocksConfig;
                }
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            }
            catch (IOException e) {
                Powershot.log.warn("Failed to write default breakable blocks config file", (Throwable)e);
                return new BreakableBlocksConfig();
            }
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            switch (GsonHelper.m_13824_((JsonObject)json, (String)SCHEMA_VERSION_KEY, (int)Integer.MAX_VALUE)) {
                case 1: {
                    Powershot.log.debug("Ignoring breakable blocks config with schema v1 containing an object");
                    BreakableBlocksConfig breakableBlocksConfig = new BreakableBlocksConfig();
                    return breakableBlocksConfig;
                }
                case 2: {
                    BreakableBlocksConfig breakableBlocksConfig = SchemaV2.read(json);
                    return breakableBlocksConfig;
                }
            }
            Powershot.log.debug("Unsupported breakable blocks config schema version: {}", (Object)json.get(SCHEMA_VERSION_KEY));
            BreakableBlocksConfig breakableBlocksConfig = SchemaV2.read(json);
            return breakableBlocksConfig;
        }
        catch (JsonSyntaxException e) {
            try (BufferedReader reader2 = new BufferedReader(new FileReader(file));){
                JsonArray json = (JsonArray)gson.fromJson((Reader)reader2, JsonArray.class);
                Powershot.log.info("Breakable blocks config file is in an outdated format. Please consider updating it");
                BreakableBlocksConfig breakableBlocksConfig = SchemaV1.read(json);
                return breakableBlocksConfig;
            }
            catch (JsonParseException | IOException e2) {
                e2.addSuppressed(e);
                Powershot.log.warn("Failed to read file " + file, e2);
                return new BreakableBlocksConfig();
            }
        }
        catch (JsonParseException | IOException e) {
            Powershot.log.warn("Failed to read file " + file, e);
            return new BreakableBlocksConfig();
        }
    }

    public record Entry(float powerRequirement, float powerReduction) {
        public static final float DEFAULT_POWER_REQUIREMENT = 1.5f;
        public static final float DEFAULT_POWER_REDUCTION = 1.5f;

        public Entry(float powerRequirement, float powerReduction) {
            this.powerRequirement = Float.isNaN(powerRequirement) ? 1.5f : powerRequirement;
            this.powerReduction = Float.isNaN(powerReduction) ? 1.5f : powerReduction;
        }

        @Override
        public String toString() {
            return String.format("[%.2f,%.2f]", Float.valueOf(this.powerRequirement), Float.valueOf(this.powerReduction));
        }
    }
}

