/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import com.gitlab.qolq.powershot.Powerable;
import com.gitlab.qolq.powershot.ReloadCommand;
import com.gitlab.qolq.powershot.config.breakableblocks.BreakableBlocksConfig;
import com.gitlab.qolq.powershot.config.powercalc.PowerCalculationConfig;
import com.gitlab.qolq.powershot.mixin.ClipContextAccessor;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="powershot")
public final class Powershot {
    public static final String MOD_ID = "powershot";
    public static final Logger log = LogManager.getLogger((String)"powershot");
    private static BreakableBlocksConfig breakableBlocksConfig;
    private static PowerCalculationConfig powerCalculationConfig;

    public Powershot() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        Powershot.loadConfigs(false);
        MinecraftForge.EVENT_BUS.addListener(e -> breakableBlocksConfig.reloadTags());
        MinecraftForge.EVENT_BUS.addListener(ReloadCommand::register);
    }

    public static void loadConfigs(boolean reloadTags) {
        Path dir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        log.debug("Loading configs from {}", (Object)dir);
        breakableBlocksConfig = BreakableBlocksConfig.from(dir.resolve("breakable_blocks.json").toFile());
        powerCalculationConfig = PowerCalculationConfig.from(dir.resolve("power_calculation.json").toFile());
        if (reloadTags) {
            breakableBlocksConfig.reloadTags();
        }
    }

    public static float calculatePower(AbstractArrow arrow, float speed) {
        LivingEntity livingShooter;
        ItemStack stack;
        float power = powerCalculationConfig.basePower() * speed;
        Entity shooter = arrow.m_37282_();
        if (shooter instanceof LivingEntity && !(stack = (livingShooter = (LivingEntity)shooter).m_21120_(livingShooter.m_7655_())).m_41619_()) {
            ListTag enchantments = stack.m_41785_();
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag enchantment = enchantments.m_128728_(i);
                ResourceLocation id = ResourceLocation.m_135820_((String)enchantment.m_128461_("id"));
                if (id == null || !powerCalculationConfig.enchantmentToMultiplier().containsKey((Object)id)) continue;
                power += (float)Mth.m_14045_((int)enchantment.m_128451_("lvl"), (int)0, (int)255) * powerCalculationConfig.enchantmentToMultiplier().getFloat((Object)id);
            }
        }
        return power;
    }

    public static BlockHitResult clip(Level level, ClipContext context, AbstractArrow arrow) {
        if (level.f_46443_) {
            return level.m_45547_(context);
        }
        Powerable powerable = (Powerable)arrow;
        BiFunction<ClipContext, BlockPos, BlockHitResult> clipFn = (clipContext, position) -> {
            BlockHitResult result;
            Vec3 start = clipContext.m_45702_();
            Vec3 end = clipContext.m_45693_();
            CollisionContext collisionContext = ((ClipContextAccessor)clipContext).getCollisionContext();
            BlockState state = level.m_8055_(position);
            VoxelShape shape = state.m_60742_((BlockGetter)level, position, collisionContext);
            BreakableBlocksConfig.Entry config = breakableBlocksConfig.get(state);
            if (config == null) {
                result = level.m_45558_(start, end, position, shape, state);
            } else {
                boolean breakable;
                boolean bl = breakable = powerable.powershot$getPower() >= config.powerRequirement();
                if (breakable && shape.m_83281_()) {
                    shape = state.m_60651_((BlockGetter)level, position, collisionContext);
                }
                result = level.m_45558_(start, end, position, shape, state);
                Entity shooter = arrow.m_37282_();
                if (breakable && result != null && Powershot.blockBreakEvent(level, shooter, position, state)) {
                    level.m_46953_(position, true, shooter);
                    powerable.powershot$setPower(powerable.powershot$getPower() - config.powerReduction());
                    result = null;
                }
            }
            if (result != null) {
                powerable.powershot$setPower(0.0f);
            }
            return result;
        };
        Function<ClipContext, BlockHitResult> missFn = clipContext -> {
            Vec3 start = clipContext.m_45702_();
            Vec3 end = clipContext.m_45693_();
            Vec3 dir = start.m_82546_(end);
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)dir.f_82479_, (double)dir.f_82480_, (double)dir.f_82481_), (BlockPos)new BlockPos(start));
        };
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)context.m_45702_(), (Vec3)context.m_45693_(), (Object)context, clipFn, missFn);
    }

    private static boolean blockBreakEvent(Level level, Entity entity, BlockPos position, BlockState state) {
        return !(entity instanceof Player) || !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, position, state, (Player)entity));
    }
}

