/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.shared.client;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.LegacyPackResourcesAdapter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.resource.DelegatingResourcePack;
import net.minecraftforge.resource.PathResourcePack;
import noppes.mpm.LogWriter;
import noppes.mpm.mixin.DelegatingResourcePackMixin;
import noppes.mpm.mixin.LegacyResourcePackWrapperMixin;

public class AssetsFinder {
    private static List<ResourceLocation> list = new ArrayList<ResourceLocation>();
    private static String root;
    private static String type;

    public static List<ResourceLocation> find(String root, String type) {
        AssetsFinder.root = root;
        AssetsFinder.type = type;
        list.clear();
        return new ArrayList<ResourceLocation>(Minecraft.m_91087_().m_91098_().m_6540_(root, r -> r.endsWith(type)));
    }

    private static File decodeFile(String url) {
        int i;
        if (url.startsWith("file:")) {
            url = url.substring(5);
        }
        if ((i = (url = url.replace('/', File.separatorChar)).indexOf(".jar")) > 0) {
            url = url.substring(0, i + 4);
        }
        try {
            url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LogWriter.except(e);
        }
        return new File(url);
    }

    private static void processResourcePack(PackResources pack) {
        if (pack instanceof LegacyPackResourcesAdapter) {
            pack = ((LegacyResourcePackWrapperMixin)pack).getSource();
        }
        if (pack instanceof DelegatingResourcePack) {
            DelegatingResourcePackMixin m = (DelegatingResourcePackMixin)pack;
            m.getAssetPacks().values().forEach(t -> t.forEach(AssetsFinder::processResourcePack));
        } else if (pack instanceof AbstractPackResources) {
            try {
                File file = null;
                if (pack instanceof PathResourcePack) {
                    Path p = ((PathResourcePack)pack).getSource();
                    file = AssetsFinder.decodeFile(p.toUri().toURL().getFile());
                } else {
                    file = ((AbstractPackResources)pack).f_10203_;
                }
                if (file != null) {
                    if (file.isDirectory()) {
                        AssetsFinder.checkFolder(file, file.getAbsolutePath().length());
                    } else {
                        AssetsFinder.progressFile(file);
                    }
                }
            }
            catch (Exception e) {
                LogWriter.except(e);
            }
        }
    }

    private static void progressFile(File file) {
        try {
            if (file.isDirectory()) {
                int length = file.getAbsolutePath().length();
                AssetsFinder.checkFolder(file, length);
            } else {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipentry = entries.nextElement();
                    String entryName = zipentry.getName();
                    AssetsFinder.addFile(entryName);
                }
                zip.close();
            }
        }
        catch (NoSuchFileException ignored) {
            LogWriter.except(ignored);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    private static void checkFolder(File file, int length) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            Object name = f.getAbsolutePath().substring(length);
            if (!((String)(name = ((String)name).replace("\\", "/"))).startsWith("/")) {
                name = "/" + (String)name;
            }
            if (f.isDirectory()) {
                AssetsFinder.addFile((String)name + "/");
                AssetsFinder.checkFolder(f, length);
                continue;
            }
            AssetsFinder.addFile((String)name);
        }
    }

    private static void addFile(String name) {
        int i;
        if ((name = name.toLowerCase()).startsWith("/")) {
            name = name.substring(1);
        }
        if (!AssetsFinder.dirValid(name) || !AssetsFinder.isValidResource(name)) {
            return;
        }
        String domain = (name = name.substring(7)).substring(0, i = name.indexOf(47));
        ResourceLocation loc = new ResourceLocation(domain, name.substring(i + 1));
        if (!list.contains(loc)) {
            list.add(loc);
        }
    }

    private static boolean dirValid(String name) {
        if (!name.toLowerCase().endsWith(type)) {
            return false;
        }
        boolean found = false;
        for (IModInfo info : ModList.get().getMods()) {
            if (!name.startsWith("assets/" + info.getModId() + "/" + root)) continue;
            found = true;
        }
        return found;
    }

    public static boolean isValidResource(String name) {
        for (char c : name.toCharArray()) {
            if (ResourceLocation.m_135816_((char)c)) continue;
            return false;
        }
        return true;
    }
}

