/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.command.EnumArgument;
import noppes.mpm.ModelData;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.packets.Packets;
import noppes.mpm.packets.client.PacketAnimationStart;
import noppes.mpm.packets.client.PacketPlayerDataSend;
import noppes.mpm.util.NoppesStringUtils;

public class CommandMPM {
    private static List<String> entities;
    private static ArgumentType<ResourceLocation> entityArgumentType;
    private static ArgumentType<EnumAnimation> animationArgumentType;
    public static final SuggestionProvider<CommandSourceStack> ENTITIES;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        entities = new ArrayList<String>();
        for (EntityType ent : ForgeRegistries.ENTITIES.getValues()) {
            if (ent.m_20674_() == MobCategory.MISC) continue;
            entities.add(ent.getRegistryName().toString());
        }
        entities.add("clear");
        LiteralArgumentBuilder command = Commands.m_82127_((String)"mpm");
        CommandMPM.getSubCommands((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)command.requires(source -> source.m_6761_(0))));
        dispatcher.register(command);
    }

    private static void getSubCommands(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(Commands.m_82127_((String)"url").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            String url = StringArgumentType.getString((CommandContext)context, (String)"url");
            if (url.equalsIgnoreCase("clear")) {
                url = "";
            }
            for (ServerPlayer player : players) {
                ModelData data = ModelData.get((Player)player);
                if (data.url.equals(url)) continue;
                data.url = url;
                Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
            }
            return players.size();
        }))));
        command.then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ENTITIES).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            return CommandMPM.setEntity((CommandContext<CommandSourceStack>)context, players, new CompoundTag());
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            return CommandMPM.setEntity((CommandContext<CommandSourceStack>)context, players, CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt"));
        })))));
        command.then(Commands.m_82127_((String)"name").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (name.equalsIgnoreCase("clear")) {
                name = "";
            }
            for (ServerPlayer player : players) {
                ModelData data = ModelData.get((Player)player);
                if (data.displayName.equals(name)) continue;
                data.displayName = name;
                Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
                player.refreshDisplayName();
            }
            return players.size();
        }))));
        command.then(Commands.m_82127_((String)"sendmodel").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            ModelData fromData = ModelData.get((Player)((CommandSourceStack)context.getSource()).m_81375_());
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            return CommandMPM.sendModel(players, fromData);
        })).then(Commands.m_82127_((String)"clear").executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            return CommandMPM.sendModel(players, new ModelData());
        }))).then(Commands.m_82129_((String)"from", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ModelData fromData = ModelData.get((Player)EntityArgument.m_91474_((CommandContext)context, (String)"from"));
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            return CommandMPM.sendModel(players, fromData);
        }))));
        command.then(Commands.m_82127_((String)"animation").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"animation", animationArgumentType).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            EnumAnimation animation = (EnumAnimation)((Object)((Object)context.getArgument("animation", EnumAnimation.class)));
            for (ServerPlayer player : players) {
                ModelData data = ModelData.get((Player)player);
                if (data.animation == animation) {
                    data.setAnimation(EnumAnimation.NONE);
                } else {
                    data.setAnimation(animation);
                }
                Packets.sendNearby((Entity)player, new PacketAnimationStart(player.m_142081_(), data.animation));
            }
            return players.size();
        }))));
        command.then(Commands.m_82127_((String)"scale").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.word()).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            Scale scale = Scale.Parse(StringArgumentType.getString((CommandContext)context, (String)"all"));
            for (ServerPlayer player : players) {
                ModelData data = ModelData.get((Player)player);
                data.head.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                data.body.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                data.arm1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                data.arm2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                data.leg1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                data.leg2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
            }
            return players.size();
        }))).then(Commands.m_82129_((String)"head", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"body", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"arms", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"legs", (ArgumentType)StringArgumentType.word()).executes(context -> {
            Collection<ServerPlayer> players = CommandMPM.getPlayers((CommandContext<CommandSourceStack>)context);
            Scale head = Scale.Parse(StringArgumentType.getString((CommandContext)context, (String)"head"));
            Scale body = Scale.Parse(StringArgumentType.getString((CommandContext)context, (String)"body"));
            Scale arms = Scale.Parse(StringArgumentType.getString((CommandContext)context, (String)"arms"));
            Scale legs = Scale.Parse(StringArgumentType.getString((CommandContext)context, (String)"legs"));
            for (ServerPlayer player : players) {
                ModelData data = ModelData.get((Player)player);
                data.head.setScale(head.scaleX, head.scaleY, head.scaleZ);
                data.body.setScale(body.scaleX, body.scaleY, body.scaleZ);
                data.arm1.setScale(arms.scaleX, arms.scaleY, arms.scaleZ);
                data.arm2.setScale(arms.scaleX, arms.scaleY, arms.scaleZ);
                data.leg1.setScale(legs.scaleX, legs.scaleY, legs.scaleZ);
                data.leg2.setScale(legs.scaleX, legs.scaleY, legs.scaleZ);
                Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
            }
            return players.size();
        })))))));
    }

    private static Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return EntityArgument.m_91477_(context, (String)"targets");
    }

    private static int sendModel(Collection<ServerPlayer> players, ModelData fromData) {
        CompoundTag compound = fromData.writeToNBT();
        for (ServerPlayer player : players) {
            ModelData data = ModelData.get((Player)player);
            data.readFromNBT(compound);
            data.save();
            Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
        }
        return players.size();
    }

    private static int setEntity(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, CompoundTag extra) throws CommandSyntaxException {
        Object resource = (ResourceLocation)context.getArgument("entity", ResourceLocation.class);
        resource = !resource.toString().equalsIgnoreCase("minecraft:clear") ? (ResourceLocation)entityArgumentType.parse(new StringReader(resource.toString())) : null;
        for (ServerPlayer player : players) {
            ModelData data = ModelData.get((Player)player);
            if (NoppesStringUtils.areEqual(data.getEntityName(), resource) && data.extra.equals((Object)extra)) continue;
            data.setEntity((ResourceLocation)resource);
            data.extra = extra;
            Packets.sendNearby((Entity)player, new PacketPlayerDataSend(player.m_142081_(), data.writeToNBT()));
        }
        return players.size();
    }

    static {
        entityArgumentType = EntitySummonArgument.m_93335_();
        animationArgumentType = EnumArgument.enumArgument(EnumAnimation.class);
        ENTITIES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("entities"), (context, builder) -> SharedSuggestionProvider.m_82981_(entities.stream(), (SuggestionsBuilder)builder));
    }

    static class Scale {
        float scaleX;
        float scaleY;
        float scaleZ;

        Scale() {
        }

        private static Scale Parse(String s) throws NumberFormatException {
            Scale scale = new Scale();
            if (s.contains(",")) {
                String[] split = s.split(",");
                if (split.length != 3) {
                    throw new NumberFormatException("Not enough args given");
                }
                scale.scaleX = Float.parseFloat(split[0]);
                scale.scaleY = Float.parseFloat(split[1]);
                scale.scaleZ = Float.parseFloat(split[2]);
            } else {
                scale.scaleY = scale.scaleX = Float.parseFloat(s);
                scale.scaleZ = scale.scaleX;
            }
            return scale;
        }
    }
}

