/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client.gui.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import noppes.mpm.client.gui.util.GuiCustomScroll;
import noppes.mpm.client.gui.util.GuiNpcButton;
import noppes.mpm.client.gui.util.GuiNpcLabel;
import noppes.mpm.client.gui.util.GuiNpcSlider;
import noppes.mpm.client.gui.util.GuiNpcTextField;
import noppes.mpm.client.gui.util.ISubGuiListener;

public abstract class GuiNPCInterface
extends Screen {
    public LocalPlayer player;
    public boolean drawDefaultBackground = true;
    private final HashMap<Integer, GuiNpcButton> npcbuttons = new HashMap();
    private final HashMap<Integer, GuiNpcTextField> textfields = new HashMap();
    private final HashMap<Integer, GuiNpcLabel> labels = new HashMap();
    private final HashMap<Integer, GuiCustomScroll> scrolls = new HashMap();
    private final HashMap<Integer, GuiNpcSlider> sliders = new HashMap();
    private final HashMap<Integer, Screen> extra = new HashMap();
    protected ResourceLocation background = null;
    public boolean closeOnEsc = false;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    private GuiNPCInterface subgui;
    public GuiNPCInterface parent;
    public int mouseX;
    public int mouseY;

    public GuiNPCInterface() {
        super((Component)new TextComponent(""));
        this.player = Minecraft.m_91087_().f_91074_;
        this.xSize = 200;
        this.ySize = 222;
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("moreplayermodels", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("moreplayermodels", "textures/gui/" + texture);
    }

    public void m_7856_() {
        super.m_7856_();
        GuiNpcTextField.unfocus();
        if (this.subgui != null) {
            this.subgui.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            this.subgui.m_7856_();
        }
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.f_169369_.clear();
        this.labels.clear();
        this.m_6702_().clear();
        this.textfields.clear();
        this.npcbuttons.clear();
        this.scrolls.clear();
        this.sliders.clear();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public void m_96624_() {
        if (this.subgui != null) {
            this.subgui.m_96624_();
        } else {
            for (GuiNpcTextField tf : this.textfields.values()) {
                if (!tf.enabled) continue;
                tf.m_94120_();
            }
            super.m_96624_();
        }
    }

    public boolean m_6375_(double i, double j, int k) {
        if (this.subgui != null) {
            return this.subgui.m_6375_(i, j, k);
        }
        for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.textfields.values())) {
            if (!tf.enabled) continue;
            tf.m_6375_(i, j, k);
        }
        if (k == 0) {
            for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
                scroll.m_6375_(i, j, k);
            }
        }
        this.mouseEvent(i, j, k);
        return super.m_6375_(i, j, k);
    }

    public void mouseEvent(double x, double y, int k) {
    }

    public void buttonEvent(GuiNpcButton button) {
    }

    public boolean m_5534_(char c, int i) {
        if (this.subgui != null) {
            return this.subgui.m_5534_(c, i);
        }
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.m_5534_(c, i);
        }
        for (GuiCustomScroll s : this.scrolls.values()) {
            s.m_5534_(c, i);
        }
        return super.m_5534_(c, i);
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.subgui != null) {
            return this.subgui.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (this.closeOnEsc && (p_keyPressed_1_ == 256 || !GuiNpcTextField.hasActive() && this.isInventoryKey(p_keyPressed_1_))) {
            this.close();
            return true;
        }
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        for (GuiCustomScroll s : this.scrolls.values()) {
            s.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void onGuiClosed() {
        this.f_96541_.f_91068_.m_90926_(false);
        GuiNpcTextField.unfocus();
    }

    public void close() {
        if (this.parent != null) {
            this.parent.closeSubGui(this);
        } else {
            this.setScreen(null);
        }
        this.save();
    }

    public void addButton(GuiNpcButton button) {
        this.npcbuttons.put(button.id, button);
        super.m_142416_((GuiEventListener)button);
    }

    public GuiNpcButton getButton(int i) {
        return this.npcbuttons.get(i);
    }

    public void addTextField(GuiNpcTextField tf) {
        this.textfields.put(tf.id, tf);
    }

    public GuiNpcTextField getTextField(int i) {
        return this.textfields.get(i);
    }

    public void addLabel(GuiNpcLabel label) {
        this.labels.put(label.id, label);
    }

    public GuiNpcLabel getLabel(int i) {
        return this.labels.get(i);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.sliders.put(slider.id, slider);
        this.m_142416_((GuiEventListener)slider);
    }

    public GuiNpcSlider getSlider(int i) {
        return this.sliders.get(i);
    }

    public void addScroll(GuiCustomScroll scroll) {
        scroll.m_6575_(this.f_96541_, scroll.f_96543_, scroll.f_96544_);
        this.scrolls.put(scroll.id, scroll);
    }

    public GuiCustomScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    public abstract void save();

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.mouseX = i;
        this.mouseY = j;
        if (this.subgui == null || this.subgui.drawSubGuiBackground()) {
            if (this.drawDefaultBackground) {
                this.m_7333_(poseStack);
            }
            if (this.background != null && this.f_96541_.m_91097_() != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.xSize > 256) {
                    this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, 250, this.ySize);
                    this.m_93228_(poseStack, this.guiLeft + 250, this.guiTop, 256 - (this.xSize - 250), 0, this.xSize - 250, this.ySize);
                } else {
                    this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
                }
            }
            for (GuiNpcLabel label : this.labels.values()) {
                label.drawLabel(poseStack, this, this.f_96547_);
            }
            for (GuiNpcTextField tf : this.textfields.values()) {
                tf.m_6305_(poseStack, i, j, f);
            }
            for (GuiCustomScroll scroll : this.scrolls.values()) {
                scroll.m_6305_(poseStack, i, j, f);
            }
            for (Screen gui : this.extra.values()) {
                gui.m_6305_(poseStack, i, j, f);
            }
            super.m_6305_(poseStack, i, j, f);
        }
        if (this.subgui != null) {
            poseStack.m_85837_(0.0, 0.0, 260.0);
            this.subgui.m_6305_(poseStack, i, j, f);
            poseStack.m_85837_(0.0, 0.0, -260.0);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrolled) {
        if (this.subgui != null) {
            this.subgui.m_6050_(mouseX, mouseY, scrolled);
        } else {
            for (GuiCustomScroll scroll : this.scrolls.values()) {
                scroll.m_6050_(mouseX, mouseY, scrolled);
            }
        }
        return true;
    }

    public boolean m_7979_(double x, double y, int button, double dx, double dy) {
        if (this.subgui != null) {
            return this.subgui.m_7979_(x, y, button, dx, dy);
        }
        return super.m_7979_(x, y, button, dx, dy);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (this.subgui != null) {
            return this.subgui.m_6348_(x, y, button);
        }
        return super.m_6348_(x, y, button);
    }

    public boolean drawSubGuiBackground() {
        return true;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void elementClicked() {
        if (this.subgui != null) {
            this.subgui.elementClicked();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void doubleClicked() {
    }

    public boolean isInventoryKey(int i) {
        return this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)i, (int)0));
    }

    public void setScreen(Screen gui) {
        this.f_96541_.m_91152_(gui);
    }

    public void setSubGui(GuiNPCInterface gui) {
        this.subgui = gui;
        this.subgui.parent = this;
        this.subgui.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.m_7856_();
    }

    public void closeSubGui(GuiNPCInterface gui) {
        this.subgui = null;
        if (this instanceof ISubGuiListener) {
            ((ISubGuiListener)((Object)this)).subGuiClosed(gui);
        }
        this.m_7856_();
    }

    public boolean hasSubGui() {
        return this.subgui != null;
    }

    public GuiNPCInterface getSubGui() {
        if (this.hasSubGui() && this.subgui.hasSubGui()) {
            return this.subgui.getSubGui();
        }
        return this.subgui;
    }

    public void drawEntity(LivingEntity entity, int x, int y, float zoomed, int rotation, int guiLeft, int guiTop) {
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        float scale = 1.0f;
        if ((double)entity.m_20206_() > 2.4) {
            scale = 2.0f / entity.m_20206_();
        }
        float f7 = (float)(guiLeft + x) - (float)this.mouseX;
        float f8 = (float)(guiTop + y) - 50.0f * scale * zoomed - (float)this.mouseY;
        entity.f_20883_ = 0.0f;
        entity.m_146922_((float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation);
        entity.m_146926_(-((float)Math.atan(f8 / 40.0f)) * 20.0f);
        entity.f_20885_ = 0.0f;
        entity.f_20886_ = 0.0f;
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)(guiLeft + x), (double)(guiTop + y), 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_(30.0f * scale * zoomed, 30.0f * scale * zoomed, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        EntityRenderDispatcher lvt_16_1_ = Minecraft.m_91087_().m_91290_();
        lvt_16_1_.m_114412_(Vector3f.f_122224_.m_122240_(180.0f));
        lvt_16_1_.m_114468_(false);
        Lighting.m_166384_();
        MultiBufferSource.BufferSource lvt_17_1_ = Minecraft.m_91087_().m_91269_().m_110104_();
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)rotation));
        RenderSystem.m_69890_(() -> lvt_16_1_.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)lvt_17_1_, 0xF000F0));
        lvt_17_1_.m_109911_();
        lvt_16_1_.m_114468_(true);
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

