/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.mpm.LogWriter;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.client.ChatMessages;
import noppes.mpm.client.ClientEventHandler;
import noppes.mpm.client.layer.LayerPreRender;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.mixin.EntityMixin;
import noppes.mpm.mixin.LivingRenderer2Mixin;
import noppes.mpm.shared.client.model.util.BatchRenderer;
import noppes.mpm.util.PixelmonHelper;

public class RenderEvent {
    public static RenderEvent Instance;
    private static Entity customEntity;
    public static ResourceLocation entityResource;

    public RenderEvent() {
        Instance = this;
        Minecraft mc = Minecraft.m_91087_();
    }

    @SubscribeEvent
    public void post(RenderLivingEvent.Post event) {
        if (entityResource != null && event.getEntity() != customEntity) {
            customEntity = null;
            entityResource = null;
        }
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        ModelData data = ModelData.get((Player)player);
        if (data.moveAnimation == EnumAnimation.SLEEP) {
            player.f_20883_ = player.f_20884_ = player.m_146909_();
        }
        BatchRenderer.getInstance().draw();
        event.getPoseStack().m_85849_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void pre(RenderLivingEvent.Pre event) {
        float offset;
        if (!(event.getEntity() instanceof AbstractClientPlayer) || event.isCanceled()) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
        PoseStack mStack = event.getPoseStack();
        mStack.m_85836_();
        if (ClientEventHandler.camera.enabled && player == mc.f_91074_) {
            player.f_20885_ = player.f_20883_;
            player.f_20886_ = player.f_20884_;
            player.f_19860_ = ClientEventHandler.camera.playerPitch;
            player.m_146926_(player.f_19860_);
            mc.f_91063_.m_109087_(MinecraftForgeClient.getPartialTick());
        }
        ModelData data = ModelData.get((Player)player);
        if (data.moveAnimation == EnumAnimation.SLEEP) {
            player.f_20883_ = player.f_20884_ = data.sleepRotation;
            player.f_20885_ = player.f_20886_ = Math.min(Math.max(player.f_20885_, data.sleepRotation - 60.0f), data.sleepRotation + 60.0f);
            player.f_19860_ = Math.min(Math.max(player.m_146909_(), 0.0f), 60.0f);
            player.m_146926_(player.f_19860_);
        }
        if (((EntityMixin)player).getDimensions().f_20378_ - (offset = data.getOffsetCamera((Player)player)) < 0.0f) {
            offset = 0.0f;
        }
        ((EntityMixin)player).setEyeHeight(player.m_20236_(player.m_20089_()) - offset);
        customEntity = data.getEntity((Player)player);
        if (customEntity != null) {
            if (ClientEventHandler.camera.enabled && player == mc.f_91074_) {
                customEntity.m_146922_(player.m_146908_());
                RenderEvent.customEntity.f_19859_ = player.f_19859_;
            }
            event.setCanceled(true);
            if (PixelmonHelper.isPixelmon(customEntity)) {
                customEntity.m_20260_(true);
            }
            entityResource = player.m_108560_();
            mc.m_91290_().m_114384_(customEntity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTick(), mStack, event.getMultiBufferSource(), event.getPackedLight());
            mStack.m_85849_();
            return;
        }
        offset = 0.0f;
        if (!MorePlayerModels.DisableFlyingAnimation && player.m_150110_().f_35935_ && player.f_19853_.m_46859_(player.m_142538_())) {
            offset = Mth.m_14089_((float)((float)player.f_19797_ * 0.1f)) * -0.06f;
        }
        if (data.moveAnimation == EnumAnimation.SIT) {
            offset = (float)((double)offset + (0.5 - (double)data.getLegsY() * 0.8));
        }
        mStack.m_85837_(0.0, (double)(-offset), 0.0);
        List layers = ((LivingRenderer2Mixin)event.getRenderer()).getLayers();
        for (RenderLayer layer : layers) {
            if (!(layer instanceof LayerPreRender)) continue;
            ((LayerPreRender)layer).preRender(player);
        }
    }

    @SubscribeEvent
    public void hand(RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ModelData data = ModelData.get((Player)mc.f_91074_);
        Pose pose = mc.f_91074_.m_20089_();
        ((EntityMixin)mc.f_91074_).setEyeHeight(mc.f_91074_.m_20236_(pose) - data.getOffsetCamera((Player)mc.f_91074_));
        LivingEntity entity = data.getEntity((Player)mc.f_91074_);
        if (entity != null || data.moveAnimation == EnumAnimation.SLEEP || data.moveAnimation == EnumAnimation.CRAWL || data.animation == EnumAnimation.BOW && mc.f_91074_.m_21205_().m_41619_()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void chat(ClientChatReceivedEvent event) {
        if (MorePlayerModels.HasServerSide) {
            return;
        }
        try {
            ChatMessages.parseMessage(event.getMessage().getString());
        }
        catch (Exception ex) {
            LogWriter.warn("Cant handle chatmessage: " + event.getMessage() + ":" + ex.getMessage());
        }
    }

    @SubscribeEvent
    public void selectionBox(DrawSelectionEvent event) {
        if (MorePlayerModels.HideSelectionBox) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || MorePlayerModels.Tooltips == 0) {
            return;
        }
        ItemStack item = mc.f_91074_.m_21205_();
        if (item.m_41619_()) {
            return;
        }
        String name = item.m_41611_().getString();
        int x = mc.m_91268_().m_85445_() - mc.f_91062_.m_92895_(name);
        int posX = 4;
        int posY = 4;
        if (MorePlayerModels.Tooltips % 2 == 0) {
            posX = x - 4;
        }
        if (MorePlayerModels.Tooltips > 2) {
            posY = mc.m_91268_().m_85446_() - 24;
        }
        mc.f_91062_.m_92750_(event.getMatrixStack(), name, (float)posX, (float)posY, 0xFFFFFF);
        if (item.m_41763_()) {
            int max = item.m_41776_();
            String dam = max - item.m_41773_() + "/" + max;
            x = mc.m_91268_().m_85445_() - mc.f_91062_.m_92895_(dam);
            if (MorePlayerModels.Tooltips == 2 || MorePlayerModels.Tooltips == 4) {
                posX = x - 4;
            }
            mc.f_91062_.m_92750_(event.getMatrixStack(), dam, (float)posX, (float)(posY + 12), 0xFFFFFF);
        }
    }

    static {
        entityResource = null;
    }
}

