/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabMPM;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import noppes.mpm.CommonProxy;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.client.ClientEventHandler;
import noppes.mpm.client.PresetController;
import noppes.mpm.client.RenderEvent;
import noppes.mpm.client.SkinUtil;
import noppes.mpm.client.VersionChecker;
import noppes.mpm.client.fx.EntityEnderFX;
import noppes.mpm.client.gui.select.GuiTextureSelection;
import noppes.mpm.client.layer.LayerBackItem;
import noppes.mpm.client.layer.LayerCapeMPM;
import noppes.mpm.client.layer.LayerChatbubble;
import noppes.mpm.client.layer.LayerElytraAlt;
import noppes.mpm.client.layer.LayerHeadwear;
import noppes.mpm.client.layer.LayerInterface;
import noppes.mpm.client.layer.LayerParts;
import noppes.mpm.client.model.animation.AnimationHandler;
import noppes.mpm.client.parts.MpmPartReader;
import noppes.mpm.mixin.ArmorLayerMixin;
import noppes.mpm.mixin.LivingRenderer2Mixin;
import noppes.mpm.mixin.ParticleManagerMixin;
import noppes.mpm.shared.client.model.util.CustomRenderStates;

public class ClientProxy
extends CommonProxy {
    public static KeyMapping Screen;
    public static KeyMapping MPM1;
    public static KeyMapping MPM2;
    public static KeyMapping MPM3;
    public static KeyMapping MPM4;
    public static KeyMapping MPM5;
    public static KeyMapping Camera;
    public static ModelData data;
    public static PlayerModel playerModel;
    public static ArmorLayerMixin armorLayer;
    public static ArmorLayerMixin armorLayerSlim;

    @Override
    public void load() {
        this.createFolders();
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        new PresetController(MorePlayerModels.dir);
        AnimationHandler.initAnimations();
        Screen = new KeyMapping("CharacterScreen", 301, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)Screen);
        MPM1 = new KeyMapping("MPM 1", 90, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)MPM1);
        MPM2 = new KeyMapping("MPM 2", -1, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)MPM2);
        MPM3 = new KeyMapping("MPM 3", -1, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)MPM3);
        MPM4 = new KeyMapping("MPM 4", -1, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)MPM4);
        MPM5 = new KeyMapping("MPM 5", -1, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)MPM5);
        Camera = new KeyMapping("MPM Camera", 341, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyMapping)Camera);
        if (MorePlayerModels.EnableUpdateChecker) {
            VersionChecker checker = new VersionChecker();
            checker.start();
        }
        ResourceManagerReloadListener listener = manager -> {
            EntityEnderFX.portalSprite = ((ParticleManagerMixin)Minecraft.m_91087_().f_91061_).getPacks().get(Registry.f_122829_.m_7981_((Object)ParticleTypes.f_123760_));
            MpmPartReader.reload();
            SkinUtil.reloadSkins();
            GuiTextureSelection.clear();
            RenderSystem.m_69879_(() -> {
                try {
                    CustomRenderStates.posTexNormalShader = new ShaderInstance((ResourceProvider)manager, "moreplayermodels:position_tex_normal", CustomRenderStates.POS_TEX_NORMAL);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        };
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)listener);
        listener.m_6213_(Minecraft.m_91087_().m_91098_());
    }

    @Override
    public void postLoad() {
        if (MorePlayerModels.InventoryGuiEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
            if (TabRegistry.getTabList().size() < 2) {
                TabRegistry.registerTab(new InventoryTabVanilla());
            }
            TabRegistry.registerTab(new InventoryTabMPM());
        }
    }

    public static void fixModels() {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher manager = mc.m_91290_();
        Map map = manager.getSkinMap();
        for (String type : map.keySet()) {
            EntityRenderer render = (EntityRenderer)map.get(type);
            ClientProxy.addLayers((PlayerRenderer)render, type.equals("slim"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLayers(PlayerRenderer playerRender, boolean slim) {
        List list;
        boolean hasMPMLayers = false;
        List list2 = list = ((LivingRenderer2Mixin)playerRender).getLayers();
        synchronized (list2) {
            for (RenderLayer layer2 : new ArrayList(list)) {
                if (!(layer2 instanceof LayerInterface)) continue;
                ((LayerInterface)layer2).setBase((PlayerModel)playerRender.m_7200_());
                hasMPMLayers = true;
            }
            if (slim) {
                armorLayerSlim = (ArmorLayerMixin)list.stream().filter(t -> t instanceof HumanoidArmorLayer).findAny().get();
            } else {
                armorLayer = (ArmorLayerMixin)list.stream().filter(t -> t instanceof HumanoidArmorLayer).findAny().get();
            }
            if (hasMPMLayers) {
                return;
            }
            list.removeIf(layer -> layer instanceof CapeLayer);
            list.removeIf(layer -> layer instanceof ElytraLayer);
            list.add(1, new LayerHeadwear(playerRender));
            list.add(new LayerCapeMPM(playerRender));
            list.add(new LayerChatbubble(playerRender));
            list.add(new LayerBackItem(playerRender));
            list.add(new LayerElytraAlt(playerRender, Minecraft.m_91087_().m_167973_()));
            list.add(new LayerParts(playerRender));
        }
    }

    public static void bindTexture2(ResourceLocation location) {
        if (location == null) {
            return;
        }
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture textureObject = manager.m_118506_(location);
        if (textureObject == null) {
            textureObject = new SimpleTexture(location);
            manager.m_118495_(location, textureObject);
        }
        textureObject.m_117966_();
    }

    @Override
    public void executor(Player player, Runnable runnable) {
        Minecraft.m_91087_().execute(runnable);
    }

    private void createFolders() {
        File meta;
        File json;
        File check;
        File file = new File(MorePlayerModels.dir, "assets/moreplayermodels");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(check = new File(file, "parts")).exists()) {
            check.mkdir();
        }
        if (!(check = new File(file, "textures")).exists()) {
            check.mkdir();
        }
        if (!(check = new File(file, "sounds")).exists()) {
            check.mkdir();
        }
        if (!(json = new File(file, "sounds.json")).exists()) {
            try {
                json.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                writer.write("{\n\n}");
                writer.close();
            }
            catch (IOException writer) {
                // empty catch block
            }
        }
        if (!(meta = new File(MorePlayerModels.dir, "pack.mcmeta")).exists()) {
            try {
                meta.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(meta));
                writer.write("{\n    \"pack\": {\n        \"description\": \"moreplayermodels map resource pack\",\n        \"pack_format\": 6\n    }\n}");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

