/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import noppes.mpm.ModelData;
import noppes.mpm.ModelEyeData;
import noppes.mpm.client.AnalyticsTracking;
import noppes.mpm.client.parts.MpmPartData;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.packets.Packets;
import noppes.mpm.packets.client.PacketBackItemUpdate;

public class ServerTickHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ModelData data = ModelData.get((Player)player);
        ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(0);
        if (data.backItem != item) {
            Packets.send(player, new PacketBackItemUpdate(player.m_142081_(), item));
            data.backItem = item;
        }
        for (MpmPartData pd : data.mpmParts) {
            if (!(pd instanceof ModelEyeData)) continue;
            ((ModelEyeData)pd).update((Player)player);
        }
        ServerTickHandler.checkMovementAnimation((Player)player, data);
        if (data.animation != EnumAnimation.NONE) {
            ServerTickHandler.checkAnimation((Player)player, data);
        }
        data.prevPosX = player.m_20185_();
        data.prevPosY = player.m_20186_();
        data.prevPosZ = player.m_20189_();
    }

    public static void checkMovementAnimation(Player player, ModelData data) {
        boolean isFlying;
        double motionX = data.prevPosX - player.m_20185_();
        double motionY = data.prevPosY - player.m_20186_();
        double motionZ = data.prevPosZ - player.m_20189_();
        double speed = motionX * motionX + motionZ * motionZ;
        boolean isMoving = speed > 0.006 && !player.m_6144_();
        boolean isJumping = motionY * motionY > 0.08;
        boolean bl = isFlying = player.f_19853_.m_46859_(player.m_142538_()) && player.f_19853_.m_46859_(player.m_142538_().m_7495_());
        if (player.m_6067_()) {
            data.setMoveAnimation(EnumAnimation.SWIM);
            return;
        }
        if (isFlying) {
            data.setMoveAnimation(isMoving ? EnumAnimation.FLY : EnumAnimation.FLY_IDLE);
            return;
        }
        if (speed < 0.001 && !isJumping && (data.moveAnimation == EnumAnimation.DEATH || data.moveAnimation == EnumAnimation.SLEEP)) {
            return;
        }
        if (data.moveAnimation == EnumAnimation.CRAWL || data.moveAnimation == EnumAnimation.SIT) {
            if (isMoving || isJumping) {
                data.setMoveAnimation(EnumAnimation.WALK);
            }
            return;
        }
        if (data.moveAnimation == EnumAnimation.CROUCH && !isMoving) {
            return;
        }
        data.setMoveAnimation(isMoving ? EnumAnimation.WALK : EnumAnimation.IDLE);
    }

    public static void checkAnimation(Player player, ModelData data) {
        boolean isJumping;
        if (data.prevPosY <= 0.0 || player.f_19797_ < 40) {
            return;
        }
        double motionX = data.prevPosX - player.m_20185_();
        double motionY = data.prevPosY - player.m_20186_();
        double motionZ = data.prevPosZ - player.m_20189_();
        double speed = motionX * motionX + motionZ * motionZ;
        boolean bl = isJumping = motionY * motionY > 0.08;
        if (data.animationTime > 0) {
            --data.animationTime;
        }
        if (player.m_5803_() || player.m_20159_() || data.animationTime == 0 || data.animation == EnumAnimation.BOW && player.m_6144_()) {
            data.setAnimation(EnumAnimation.NONE);
        }
        if (!isJumping && player.m_6144_() && (data.animation == EnumAnimation.HUG || data.animation == EnumAnimation.DANCE)) {
            return;
        }
        if (speed > 0.01 || isJumping || player.m_5803_() || data.animation == EnumAnimation.SLEEP && speed > 0.001) {
            data.setAnimation(EnumAnimation.NONE);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = event.getPlayer().m_20194_();
        ModelData data = ModelData.get(event.getPlayer());
        String serverType = "local";
        if (server.m_6982_()) {
            serverType = "server";
        } else if (server.m_6992_()) {
            serverType = "lan";
        }
        AnalyticsTracking.sendData(data.analyticsUUID, "join", serverType);
    }
}

