/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class TextSplitter {
    public static int splitTextIntoLines(List<Component> dest, int minWidth, int widthLimit, FormattedText formattedText, StringBuilder plainTextBuilder) {
        SplitProgress progress = new SplitProgress();
        int spaceWidth = Minecraft.m_91087_().f_91062_.m_92895_(" ");
        progress.resultWidth = minWidth;
        FormattedText.StyledContentConsumer consumer = (style, text) -> {
            boolean endsWithSpace;
            boolean isEnd;
            boolean bl = isEnd = style == null;
            if (!isEnd && plainTextBuilder != null) {
                plainTextBuilder.append(text);
            }
            if (endsWithSpace = ((String)text).endsWith(" ")) {
                text = (String)text + ".";
            }
            String[] parts = ((String)text).split(" ");
            for (int i = 0; i < parts.length; ++i) {
                boolean isNewLine;
                boolean canAddMultiword = isEnd || i < parts.length - 1;
                String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                int partWidth = Minecraft.m_91087_().f_91062_.m_92895_(part);
                if (!canAddMultiword) {
                    progress.buildMultiword(part, partWidth, style);
                    continue;
                }
                int wordWidth = partWidth + progress.multiwordWidth;
                int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                if (progress.lineWidth + wordTakesWidth <= widthLimit) {
                    progress.resultWidth = Math.max(progress.resultWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth));
                }
                if (progress.firstWord && progress.lineWidth + wordTakesWidth > progress.resultWidth) {
                    progress.resultWidth = progress.lineWidth + wordTakesWidth;
                }
                boolean bl2 = isNewLine = progress.multiword == null && part.equals("\n");
                if (!isNewLine && progress.lineWidth + wordTakesWidth <= progress.resultWidth) {
                    progress.confirmWord(part, style, wordTakesWidth);
                    continue;
                }
                progress.confirmComponent();
                dest.add(progress.line);
                progress.nextLine();
                if (isNewLine) continue;
                --i;
            }
            return Optional.empty();
        };
        formattedText.m_7451_(consumer, Style.f_131099_.m_131140_(ChatFormatting.WHITE));
        if (progress.multiword != null) {
            consumer.m_7164_(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (progress.resultWidth > minWidth) {
            --progress.resultWidth;
        }
        return progress.resultWidth;
    }

    public static class SplitProgress {
        int multiwordWidth;
        List<MutableComponent> multiword = null;
        boolean firstWord = true;
        Component line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        Style lastStyle;
        int resultWidth;

        public void buildMultiword(String wordPart, int width, Style style) {
            MutableComponent wordPartComponent = new TextComponent(wordPart).m_130948_(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<MutableComponent>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, Style style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, Style lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (Component component : this.multiword) {
                    String text = component.m_6111_();
                    Style style = component.m_7383_();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            MutableComponent comp = new TextComponent(this.stringBuilder.toString()).m_130948_(this.lastStyle == null ? Style.f_131099_ : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.m_7360_().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

