/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;
import xaero.map.gui.CursorBox;
import xaero.map.gui.ICanTooltip;
import xaero.map.gui.IScreenBase;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.misc.Misc;

public class ScreenBase
extends Screen
implements IScreenBase {
    public Screen parent;
    public Screen escape;
    protected boolean canSkipWorldRender;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;

    protected ScreenBase(Screen parent, Screen escape, Component titleIn) {
        super(titleIn);
        this.parent = parent;
        this.escape = escape;
        this.canSkipWorldRender = true;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    protected void onExit(Screen screen) {
        this.f_96541_.m_91152_(screen);
    }

    protected void goBack() {
        this.onExit(this.parent);
    }

    public void m_7379_() {
        this.onExit(this.escape);
    }

    public void renderEscapeScreen(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        GlStateManager.m_84266_((int)256, (boolean)Minecraft.f_91002_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        super.m_6305_(poseStack, mouseX, mouseY, partial);
        this.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.m_6305_(poseStack, mouseX, mouseY, partial);
        }
        if (this.openDropdown != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 2.0);
            this.openDropdown.render(poseStack, mouseX, mouseY, this.f_96544_, false);
            poseStack.m_85849_();
        }
    }

    protected void renderPreDropdown(PoseStack poseStack, int mouseX, int mouseY, float partial) {
    }

    protected void m_7856_() {
        super.m_7856_();
        this.dropdowns.clear();
        this.openDropdown = null;
        if (this.escape != null) {
            this.escape.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.f_96544_)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.m_6375_(mouseX, mouseY, button);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.f_96544_)) {
                return this.openDropdown.m_6050_(mouseX, mouseY, wheel);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, wheel);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null && this.openDropdown.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && Misc.screenShouldSkipWorldRender(this.escape, true);
    }

    protected boolean renderTooltips(PoseStack matrixStack, int par1, int par2, float par3) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 2.1);
        boolean result = false;
        boolean mousePressed = GLFW.glfwGetMouseButton((long)this.f_96541_.m_91268_().m_85439_(), (int)0) == 1;
        for (GuiEventListener el : this.m_6702_()) {
            CursorBox tooltip;
            AbstractWidget b;
            if (!(el instanceof AbstractWidget) || !((b = (AbstractWidget)el) instanceof ICanTooltip) || b instanceof SliderButton && mousePressed) continue;
            ICanTooltip canTooltip = (ICanTooltip)b;
            if (par1 < b.f_93620_ || par2 < b.f_93621_ || par1 >= b.f_93620_ + b.m_5711_() || par2 >= b.f_93621_ + b.m_93694_() || canTooltip.getXaero_wm_tooltip() == null || (tooltip = canTooltip.getXaero_wm_tooltip().get()) == null) continue;
            tooltip.drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
            result = true;
            break;
        }
        matrixStack.m_85849_();
        return result;
    }

    public Screen getEscape() {
        return this.escape;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T guiEventListener) {
        if (guiEventListener instanceof DropDownWidget) {
            this.dropdowns.add((DropDownWidget)guiEventListener);
        }
        return (T)super.m_7787_(guiEventListener);
    }

    private void handleDropdownReplacement(AbstractWidget current, AbstractWidget replacement) {
        int dropdownIndex = this.dropdowns.indexOf(current);
        if (dropdownIndex != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
        if (this.m_7222_() == current) {
            this.m_7522_((GuiEventListener)replacement);
        }
    }

    private void replaceWidget(AbstractWidget current, AbstractWidget replacement, boolean renderable) {
        int childIndex = this.m_6702_().indexOf(current);
        if (childIndex != -1) {
            super.m_169411_((GuiEventListener)current);
            if (renderable) {
                super.m_142416_((GuiEventListener)replacement);
            } else {
                super.m_7787_((GuiEventListener)replacement);
            }
            this.m_6702_().remove(replacement);
            this.m_6702_().add(childIndex, replacement);
        }
        this.handleDropdownReplacement(current, replacement);
    }

    public void replaceWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, false);
    }

    public void replaceRenderableWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, true);
    }

    protected void m_169411_(GuiEventListener current) {
        this.dropdowns.remove(current);
        super.m_169411_(current);
    }
}

