/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private DropDownWidget createdDropdown;
    private Button switchingButton;
    private Button multiworldTypeOptionButton;
    private Button renameButton;
    private Button deleteButton;
    private Button confirmButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, Minecraft field_230706_i_, int field_230708_k_, int field_230709_l_) {
        this.createdDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        this.settingsDimension = mapScreen.getDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null && this.settingsDimension.getMapWorld().isMultiplayer();
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, field_230709_l_ - 20, b -> {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canToggleThisScreen()) {
                        return;
                    }
                    this.active = !this.active;
                    mapScreen.m_6575_(field_230706_i_, field_230708_k_, field_230709_l_);
                    mapScreen.m_7522_((GuiEventListener)this.switchingButton);
                }
            });
            mapScreen.addButton(this.switchingButton);
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                if (this.active) {
                    this.createdDropdown = this.createDropdown(this.uiPausedOnUpdate, field_230708_k_, mapScreen, field_230706_i_);
                    mapScreen.m_7787_(this.createdDropdown);
                    this.multiworldTypeOptionButton = new TooltipButton(field_230708_k_ / 2 - 90, 24, 180, 20, (Component)new TextComponent(this.getMultiworldTypeButtonMessage()), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (this.isMapSelectionOptionEnabled()) {
                                this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                                b.m_93666_((Component)new TextComponent(this.getMultiworldTypeButtonMessage()));
                            }
                        }
                    }, this.settingsDimension.isFutureMultiworldServerBased() ? () -> this.serverSelectionModeBox : () -> this.mapSelectionBox);
                    mapScreen.addButton(this.multiworldTypeOptionButton);
                    this.renameButton = new Button(field_230708_k_ / 2 + 109, 60, 60, 20, (Component)new TranslatableComponent("gui.xaero_rename"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canRenameMap()) {
                                return;
                            }
                            field_230706_i_.m_91152_((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
                        }
                    });
                    mapScreen.addButton(this.renameButton);
                    this.deleteButton = new Button(field_230708_k_ / 2 - 168, 60, 60, 20, (Component)new TranslatableComponent("gui.xaero_delete"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canDeleteMap()) {
                                return;
                            }
                            String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                            field_230706_i_.m_91152_((Screen)new ConfirmScreen(result -> {
                                if (result) {
                                    String mapNameAndIdLine = I18n.m_118938_((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                    field_230706_i_.m_91152_((Screen)new ConfirmScreen(result2 -> {
                                        if (result2) {
                                            Object object = this.mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Delayed map deletion!");
                                                        }
                                                        this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Instant map deletion!");
                                                        }
                                                        this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    this.settingsDimension.saveConfigUnsynced();
                                                    this.settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.m_6575_(field_230706_i_, field_230708_k_, field_230709_l_);
                                                }
                                            }
                                        }
                                        field_230706_i_.m_91152_((Screen)mapScreen);
                                    }, (Component)new TranslatableComponent("gui.xaero_delete_map_msg3"), (Component)new TextComponent(mapNameAndIdLine)));
                                } else {
                                    field_230706_i_.m_91152_((Screen)mapScreen);
                                }
                            }, (Component)new TranslatableComponent("gui.xaero_delete_map_msg1"), (Component)new TranslatableComponent("gui.xaero_delete_map_msg2")));
                        }
                    });
                    mapScreen.addButton(this.deleteButton);
                    this.confirmButton = new Button(field_230708_k_ / 2 - 50, 84, 100, 20, (Component)new TranslatableComponent("gui.xaero_confirm"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canConfirm()) {
                                return;
                            }
                            this.confirm(mapScreen, field_230706_i_, field_230708_k_, field_230709_l_);
                        }
                    });
                    mapScreen.addButton(this.confirmButton);
                    this.updateButtons(mapScreen, field_230708_k_, field_230706_i_);
                } else {
                    this.switchingButton.f_93623_ = this.canToggleThisScreen();
                }
            } else {
                this.switchingButton.f_93623_ = false;
            }
        }
    }

    private DropDownWidget createDropdown(boolean paused, int width, GuiMap mapScreen, Minecraft minecraft) {
        List<CallSite> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther<String>(mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            Collections.sort(sortableList);
            ArrayList<String> dropdownValuesList = new ArrayList<String>();
            for (KeySortableByOther keySortableByOther : sortableList) {
                dropdownValuesList.add((String)keySortableByOther.getKey());
            }
            selected = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
            if (selected == dropdownValuesList.size()) {
                dropdownValuesList.add(currentMultiworld);
            }
            this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
            mwDropdownNames = dropdownValuesList.stream().map(s -> this.settingsDimension.getMultiworldName((String)s)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                mwDropdownNames.add((CallSite)((Object)("\u00a78" + I18n.m_118938_((String)"gui.xaero_create_new_map", (Object[])new Object[0]))));
            }
        } else {
            mwDropdownNames = new ArrayList<CallSite>();
            this.mwDropdownValues = null;
            mwDropdownNames.add((CallSite)((Object)("\u00a77" + I18n.m_118938_((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]))));
        }
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(mwDropdownNames.toArray(new String[0])).setX(width / 2 - 100).setY(64).setW(200).setSelected(selected).setCallback((dd, i) -> {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.isUIPaused() || this.uiPausedOnUpdate) {
                    return false;
                }
                if (i < this.mwDropdownValues.length) {
                    this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                    this.updateButtons(mapScreen, width, minecraft);
                    return true;
                }
                minecraft.m_91152_((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                return false;
            }
        }).setContainer(mapScreen).setNarrationTitle((Component)new TranslatableComponent("gui_xaero_wm_dropdown_map_select")).build();
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(GuiMap mapScreen, int width, Minecraft minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                DropDownWidget newDropDown;
                DropDownWidget dropDownWidget = newDropDown = !this.active ? null : this.createDropdown(isPaused, width, mapScreen, minecraft);
                if (newDropDown != null) {
                    if (this.createdDropdown != null) {
                        mapScreen.replaceWidget(this.createdDropdown, newDropDown);
                    } else {
                        mapScreen.m_7787_(newDropDown);
                    }
                } else if (this.createdDropdown != null) {
                    mapScreen.m_169411_((GuiEventListener)this.createdDropdown);
                }
                this.createdDropdown = !this.active ? null : newDropDown;
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.f_93623_ = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.f_93623_ = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.f_93623_ = this.canRenameMap();
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.f_93623_ = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.f_93623_ = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.m_118938_((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.m_6575_(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.m_6575_(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdDropdown == null || this.createdDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && this.createdDropdown.isClosed() && !this.uiPausedOnUpdate && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[this.createdDropdown.getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.m_6575_(minecraft, width, height);
        }
    }

    public void renderText(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.m_118938_((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        MultiBufferSource.BufferSource renderTypeBuffers = this.mapProcessor.getCvc().getRenderTypeBuffers();
        VertexConsumer backgroundVertexBuffer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_COLOR_OVERLAY);
        MapRenderHelper.drawStringWithBackground(matrixStack, minecraft.f_91062_, selectMapString, width / 2 - minecraft.f_91062_.m_92895_(selectMapString) / 2, 49, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
        renderTypeBuffers.m_109911_();
    }

    public void postMapRender(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

