/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.PixelBuffers;
import xaero.map.pool.PoolUnit;
import xaero.map.region.texture.BranchTextureRenderer;

public abstract class TextureUpload
implements PoolUnit {
    protected int glTexture;
    private int glUnpackPbo;
    private int target;
    private int level;
    private int internalFormat;
    private int width;
    private int height;
    private int border;
    private long pixels_buffer_offset;
    private int uploadType;

    @Override
    public void create(Object ... args) {
        this.glTexture = (Integer)args[0];
        this.glUnpackPbo = (Integer)args[1];
        this.target = (Integer)args[2];
        this.level = (Integer)args[3];
        this.internalFormat = (Integer)args[4];
        this.width = (Integer)args[5];
        this.height = (Integer)args[6];
        this.border = (Integer)args[7];
        this.pixels_buffer_offset = (Long)args[8];
    }

    public void run() throws OpenGLException {
        GlStateManager.m_84544_((int)this.glTexture);
        PixelBuffers.glBindBuffer(35052, this.glUnpackPbo);
        this.upload();
        OpenGLException.checkGLError();
        PixelBuffers.glBindBuffer(35052, 0);
        GlStateManager.m_84544_((int)0);
        OpenGLException.checkGLError();
    }

    abstract void upload() throws OpenGLException;

    public int getUploadType() {
        return this.uploadType;
    }

    public static class BranchDownload
    extends TextureUpload {
        private int glPackPbo;
        private int pboOffset;

        public BranchDownload(int uploadType) {
            this.uploadType = uploadType;
        }

        public BranchDownload(Object ... args) {
            this(5);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            PixelBuffers.glBindBuffer(35051, this.glPackPbo);
            int target = this.target;
            GL11.glGetTexImage((int)target, (int)0, (int)32993, (int)32821, (long)this.pboOffset);
            PixelBuffers.glBindBuffer(35051, 0);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.glPackPbo = (Integer)args[9];
            this.pboOffset = (Integer)args[10];
        }
    }

    public static class BranchUpdate
    extends TextureUpload {
        private int format;
        private int type;
        private boolean allocate;
        private Integer srcTextureTopLeft;
        private Integer srcTextureTopRight;
        private Integer srcTextureBottomLeft;
        private Integer srcTextureBottomRight;
        private BranchTextureRenderer renderer;
        private int glPackPbo;
        private int pboOffset;

        public BranchUpdate(int uploadType) {
            this.uploadType = uploadType;
        }

        public BranchUpdate(Object ... args) {
            this((Boolean)args[11] != false ? 4 : 3);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            if (this.allocate) {
                GL11.glTexImage2D((int)this.target, (int)this.level, (int)this.internalFormat, (int)this.width, (int)this.height, (int)0, (int)this.format, (int)this.type, (ByteBuffer)null);
                OpenGLException.checkGLError();
            }
            this.renderer.render(this.glTexture, this.srcTextureTopLeft, this.srcTextureTopRight, this.srcTextureBottomLeft, this.srcTextureBottomRight, Minecraft.m_91087_().m_91385_(), this.allocate);
            GlStateManager.m_84544_((int)this.glTexture);
            PixelBuffers.glBindBuffer(35051, this.glPackPbo);
            int target = this.target;
            GL11.glGetTexImage((int)target, (int)0, (int)32993, (int)32821, (long)this.pboOffset);
            PixelBuffers.glBindBuffer(35051, 0);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.format = (Integer)args[9];
            this.type = (Integer)args[10];
            this.allocate = (Boolean)args[11];
            this.srcTextureTopLeft = (Integer)args[12];
            this.srcTextureTopRight = (Integer)args[13];
            this.srcTextureBottomLeft = (Integer)args[14];
            this.srcTextureBottomRight = (Integer)args[15];
            this.renderer = (BranchTextureRenderer)args[16];
            this.glPackPbo = (Integer)args[17];
            this.pboOffset = (Integer)args[18];
        }
    }

    public static class Compressed
    extends TextureUpload {
        private int dataSize;

        public Compressed(Object ... args) {
            this.create(args);
            this.uploadType = 2;
        }

        @Override
        void upload() throws OpenGLException {
            GL13.glCompressedTexImage2D((int)this.target, (int)this.level, (int)this.internalFormat, (int)this.width, (int)this.height, (int)this.border, (int)this.dataSize, (long)this.pixels_buffer_offset);
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.dataSize = (Integer)args[9];
        }
    }

    public static class SubsequentNormal
    extends TextureUpload {
        private int format;
        private int type;
        private int xOffset;
        private int yOffset;

        public SubsequentNormal(int uploadType) {
            this.uploadType = uploadType;
        }

        public SubsequentNormal(Object ... args) {
            this(6);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            GL11.glTexSubImage2D((int)this.target, (int)this.level, (int)this.xOffset, (int)this.yOffset, (int)this.width, (int)this.height, (int)this.format, (int)this.type, (long)this.pixels_buffer_offset);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.format = (Integer)args[9];
            this.type = (Integer)args[10];
            this.xOffset = (Integer)args[11];
            this.yOffset = (Integer)args[12];
        }
    }

    public static class Normal
    extends TextureUpload {
        private int format;
        private int type;

        public Normal(int uploadType) {
            this.uploadType = uploadType;
        }

        public Normal(Object ... args) {
            this(0);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            GL11.glHint((int)34031, (int)4354);
            OpenGLException.checkGLError();
            GL11.glTexImage2D((int)this.target, (int)this.level, (int)this.internalFormat, (int)this.width, (int)this.height, (int)0, (int)this.format, (int)this.type, (long)this.pixels_buffer_offset);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.format = (Integer)args[9];
            this.type = (Integer)args[10];
        }
    }
}

