/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import github.pitbox46.itemblacklist.ItemBlacklist;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonUtils {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public static File initialize(Path folder, String folderName, String fileName) {
        File file = new File(FileUtils.getOrCreateDirectory((Path)folder, (String)folderName).toFile(), fileName);
        try {
            if (file.createNewFile()) {
                Path defaultConfigPath = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("itemblacklist.json");
                if (Files.exists(defaultConfigPath, new LinkOption[0])) {
                    Files.copy(defaultConfigPath, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    FileWriter configWriter = new FileWriter(file);
                    configWriter.write(gson.toJson((JsonElement)new JsonArray()));
                    configWriter.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        return file;
    }

    public static List<Item> readItemsFromJson(File jsonFile) {
        try {
            FileReader reader = new FileReader(jsonFile);
            JsonArray array = (JsonArray)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonArray.class);
            ArrayList<Item> returnedArrays = new ArrayList<Item>();
            assert (array != null);
            for (JsonElement element : array) {
                Item item = ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()))).m_5456_();
                if (item == null || item instanceof AirItem) continue;
                returnedArrays.add(item);
            }
            return returnedArrays;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void appendItemToJson(File jsonFile, Item item) {
        try (FileReader reader = new FileReader(jsonFile);){
            JsonArray array = (JsonArray)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonArray.class);
            assert (array != null);
            JsonPrimitive string = new JsonPrimitive(item.getRegistryName().toString());
            if (!array.contains((JsonElement)string)) {
                array.add((JsonElement)string);
            }
            try (FileWriter fileWriter = new FileWriter(jsonFile);){
                fileWriter.write(gson.toJson((JsonElement)array));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ItemBlacklist.BANNED_ITEMS = JsonUtils.readItemsFromJson(ItemBlacklist.BANLIST);
    }

    public static void removeItemFromJson(File jsonFile, Item item) throws IndexOutOfBoundsException {
        try (FileReader reader = new FileReader(jsonFile);){
            JsonArray array = (JsonArray)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonArray.class);
            assert (array != null);
            int itemLocation = -1;
            int i = 0;
            for (JsonElement element : array) {
                if (element.getAsString().equals(item.getRegistryName().toString())) {
                    itemLocation = i;
                }
                ++i;
            }
            array.remove(itemLocation);
            try (FileWriter fileWriter = new FileWriter(jsonFile);){
                fileWriter.write(gson.toJson((JsonElement)array));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ItemBlacklist.BANNED_ITEMS = JsonUtils.readItemsFromJson(ItemBlacklist.BANLIST);
    }

    public static void removeAllItemsFromJson(File jsonFile) throws IndexOutOfBoundsException {
        try (FileWriter fileWriter = new FileWriter(jsonFile);){
            fileWriter.write(gson.toJson((JsonElement)new JsonArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ItemBlacklist.BANNED_ITEMS = JsonUtils.readItemsFromJson(ItemBlacklist.BANLIST);
    }
}

