/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.client.ClientOnlyMethods;
import aurilux.titles.common.ServerOnlyMethods;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.network.TitlesNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncNickname {
    private final String nickname;
    private final UUID playerUUID;

    public PacketSyncNickname(UUID uuid, String nick) {
        this.playerUUID = uuid;
        this.nickname = nick;
    }

    public static void encode(PacketSyncNickname msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.playerUUID.toString());
        buf.m_130070_(msg.nickname);
    }

    public static PacketSyncNickname decode(FriendlyByteBuf buf) {
        UUID uuid = UUID.fromString(buf.m_130136_(Short.MAX_VALUE));
        String nick = buf.m_130277_();
        return new PacketSyncNickname(uuid, nick);
    }

    public static void handle(PacketSyncNickname msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Player player = ServerOnlyMethods.getPlayerByUUID(msg.playerUUID);
                TitleManager.setNickname(player, msg.nickname);
                TitlesNetwork.toAll(new PacketSyncNickname(msg.playerUUID, msg.nickname));
            } else {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.handleClient(msg));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class Handler {
        public static DistExecutor.SafeRunnable handleClient(final PacketSyncNickname msg) {
            return new DistExecutor.SafeRunnable(){

                public void run() {
                    Player player = ClientOnlyMethods.getPlayerByUUID(msg.playerUUID);
                    TitleManager.setNickname(player, msg.nickname);
                }
            };
        }
    }
}

