/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.client.ClientOnlyMethods;
import aurilux.titles.common.ServerOnlyMethods;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncGenderSetting {
    private final boolean gender;
    private final UUID playerUUID;

    public PacketSyncGenderSetting(UUID uuid, boolean setting) {
        this.playerUUID = uuid;
        this.gender = setting;
    }

    public static void encode(PacketSyncGenderSetting msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.playerUUID.toString());
        buf.writeBoolean(msg.gender);
    }

    public static PacketSyncGenderSetting decode(FriendlyByteBuf buf) {
        UUID uuid = UUID.fromString(buf.m_130136_(Short.MAX_VALUE));
        boolean setting = buf.readBoolean();
        return new PacketSyncGenderSetting(uuid, setting);
    }

    public static void handle(PacketSyncGenderSetting msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Player player = ServerOnlyMethods.getPlayerByUUID(msg.playerUUID);
                TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> cap.setGenderSetting(msg.gender)));
                player.refreshDisplayName();
                TitlesNetwork.toAll(new PacketSyncGenderSetting(msg.playerUUID, msg.gender));
            } else {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.handleClient(msg));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class Handler {
        public static DistExecutor.SafeRunnable handleClient(final PacketSyncGenderSetting msg) {
            return new DistExecutor.SafeRunnable(){

                public void run() {
                    Player player = ClientOnlyMethods.getPlayerByUUID(msg.playerUUID);
                    TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> cap.setGenderSetting(msg2.gender)));
                    player.refreshDisplayName();
                }
            };
        }
    }
}

