/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.client.ClientOnlyMethods;
import aurilux.titles.common.ServerOnlyMethods;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.network.TitlesNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncDisplayTitle {
    private final UUID playerUUID;
    private final ResourceLocation displayTitle;

    public PacketSyncDisplayTitle(UUID uuid, ResourceLocation titleKey) {
        this.playerUUID = uuid;
        this.displayTitle = titleKey;
    }

    public static void encode(PacketSyncDisplayTitle msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.playerUUID.toString());
        buf.m_130070_(msg.displayTitle.toString());
    }

    public static PacketSyncDisplayTitle decode(FriendlyByteBuf buf) {
        UUID uuid = UUID.fromString(buf.m_130277_());
        String titleKey = buf.m_130277_();
        return new PacketSyncDisplayTitle(uuid, new ResourceLocation(titleKey));
    }

    public static void handle(PacketSyncDisplayTitle msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Player player = ServerOnlyMethods.getPlayerByUUID(msg.playerUUID);
                TitleManager.setDisplayTitle(player, msg.displayTitle);
                TitlesNetwork.toAll(new PacketSyncDisplayTitle(msg.playerUUID, msg.displayTitle));
            } else {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.handleClient(msg));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class Handler {
        public static DistExecutor.SafeRunnable handleClient(final PacketSyncDisplayTitle msg) {
            return new DistExecutor.SafeRunnable(){

                public void run() {
                    Player player = ClientOnlyMethods.getPlayerByUUID(msg.playerUUID);
                    TitleManager.setDisplayTitle(player, msg.displayTitle);
                }
            };
        }
    }
}

