/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.api.Title;
import aurilux.titles.common.core.TitleRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncDatapack {
    private final Map<ResourceLocation, Title> allLoadedTitles;
    private final int count;

    public PacketSyncDatapack() {
        this(TitleRegistry.get().getTitles());
    }

    public PacketSyncDatapack(Map<ResourceLocation, Title> allLoadedTitles) {
        this.allLoadedTitles = allLoadedTitles;
        this.count = this.allLoadedTitles.size();
    }

    public static void encode(PacketSyncDatapack msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.count);
        for (Map.Entry<ResourceLocation, Title> entry : msg.allLoadedTitles.entrySet()) {
            String test = entry.getKey().toString();
            buf.m_130070_(test);
            String test2 = entry.getValue().serialize().toString();
            buf.m_130070_(test2);
        }
    }

    public static PacketSyncDatapack decode(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, Title> temp = new HashMap<ResourceLocation, Title>();
        int testInt = buf.readInt();
        for (int i = 0; i < testInt; ++i) {
            String test = buf.m_130277_();
            ResourceLocation res = new ResourceLocation(test);
            String test2 = buf.m_130277_();
            temp.put(res, Title.Builder.deserialize(GsonHelper.m_13864_((String)test2)).build());
        }
        return new PacketSyncDatapack(temp);
    }

    public Map<ResourceLocation, Title> getAllLoadedTitles() {
        return this.allLoadedTitles;
    }

    public static void handle(final PacketSyncDatapack msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                TitleRegistry.get().processServerData(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

