/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network.messages;

import aurilux.titles.common.core.TitleManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncAllDisplayTitles {
    private final Map<UUID, ResourceLocation> playerDisplayTitles;

    public PacketSyncAllDisplayTitles(Map<UUID, ResourceLocation> playerDisplayTitles) {
        this.playerDisplayTitles = playerDisplayTitles;
    }

    public static void encode(PacketSyncAllDisplayTitles msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.playerDisplayTitles.entrySet().size());
        for (Map.Entry<UUID, ResourceLocation> entry : msg.playerDisplayTitles.entrySet()) {
            buf.m_130070_(entry.getKey().toString());
            buf.m_130070_(entry.getValue().toString());
        }
    }

    public static PacketSyncAllDisplayTitles decode(FriendlyByteBuf buf) {
        HashMap<UUID, ResourceLocation> map = new HashMap<UUID, ResourceLocation>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(UUID.fromString(buf.m_130277_()), new ResourceLocation(buf.m_130277_()));
        }
        return new PacketSyncAllDisplayTitles(map);
    }

    public static void handle(final PacketSyncAllDisplayTitles msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world != null) {
                    for (Map.Entry<UUID, ResourceLocation> entry : msg.playerDisplayTitles.entrySet()) {
                        Player otherPlayer = world.m_46003_(entry.getKey());
                        TitleManager.setDisplayTitle(otherPlayer, entry.getValue());
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

