/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.network;

import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.network.messages.PacketSyncAllDisplayTitles;
import aurilux.titles.common.network.messages.PacketSyncDatapack;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import aurilux.titles.common.network.messages.PacketSyncGenderSetting;
import aurilux.titles.common.network.messages.PacketSyncNickname;
import aurilux.titles.common.network.messages.PacketSyncTitlesCapability;
import aurilux.titles.common.network.messages.PacketSyncUnlockedTitle;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TitlesNetwork {
    private static final String protocol = "1";
    private static SimpleChannel CHANNEL;
    private static int index;

    public static void init() {
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)TitlesMod.prefix("main")).networkProtocolVersion(() -> protocol).clientAcceptedVersions(protocol::equals).serverAcceptedVersions(protocol::equals).simpleChannel();
        CHANNEL.registerMessage(index++, PacketSyncUnlockedTitle.class, PacketSyncUnlockedTitle::encode, PacketSyncUnlockedTitle::decode, PacketSyncUnlockedTitle::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(index++, PacketSyncAllDisplayTitles.class, PacketSyncAllDisplayTitles::encode, PacketSyncAllDisplayTitles::decode, PacketSyncAllDisplayTitles::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(index++, PacketSyncTitlesCapability.class, PacketSyncTitlesCapability::encode, PacketSyncTitlesCapability::decode, PacketSyncTitlesCapability::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(index++, PacketSyncDatapack.class, PacketSyncDatapack::encode, PacketSyncDatapack::decode, PacketSyncDatapack::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(index++, PacketSyncNickname.class, PacketSyncNickname::encode, PacketSyncNickname::decode, PacketSyncNickname::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(index++, PacketSyncDisplayTitle.class, PacketSyncDisplayTitle::encode, PacketSyncDisplayTitle::decode, PacketSyncDisplayTitle::handle);
        CHANNEL.registerMessage(index++, PacketSyncGenderSetting.class, PacketSyncGenderSetting::encode, PacketSyncGenderSetting::decode, PacketSyncGenderSetting::handle);
    }

    public static void toServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void toPlayer(Object msg, ServerPlayer player) {
        CHANNEL.sendTo(msg, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void toAll(Object msg) {
        TitlesNetwork.toAllExcept(msg, null);
    }

    public static void toAllExcept(Object msg, ServerPlayer ignoredPlayer) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (ignoredPlayer == null || player != ignoredPlayer) {
                TitlesNetwork.toPlayer(msg, player);
                continue;
            }
            TitlesMod.LOG.info("Ignored specified player: {}", (Object)ignoredPlayer.m_5446_().getString());
        }
    }

    static {
        index = 0;
    }
}

