/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.entity.merchant.villager.TitleForEmeraldsAndFragmentsTrade;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;

public class ConfigEventHandler {
    public static void onTabListNameFormat(PlayerEvent.TabListNameFormat event) {
        Player player = event.getPlayer();
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> event.setDisplayName((Component)TitleManager.getFormattedDisplayName(cap.getDisplayTitle(), player, cap))));
    }

    public static void addLoot(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "simple_dungeon": 
                case "stronghold_corridor": 
                case "stronghold_crossing": 
                case "stronghold_library": {
                    event.getTable().addPool(ConfigEventHandler.getInjectPool(file));
                }
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        ResourceLocation table = TitlesMod.prefix("inject/" + entryName);
        LootPoolSingletonContainer.Builder entry = LootTableReference.m_79776_((ResourceLocation)table).m_79707_(1);
        return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)entry).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("titles_inject").m_79082_();
    }

    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals(VillagerProfession.f_35594_)) {
            ((List)event.getTrades().get(1)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.COMMON, 3, 5));
            ((List)event.getTrades().get(3)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.UNCOMMON, 2, 10));
            ((List)event.getTrades().get(5)).add(new TitleForEmeraldsAndFragmentsTrade(Rarity.RARE, 1, 30));
        }
    }
}

