/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncAllDisplayTitles;
import aurilux.titles.common.network.messages.PacketSyncDatapack;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import aurilux.titles.common.network.messages.PacketSyncTitlesCapability;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="titles")
public class CommonEventHandler {
    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(TitlesCapability.NAME, (ICapabilityProvider)new TitlesCapability.Provider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        TitleManager.doIfPresent(original, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)oldCap -> TitleManager.doIfPresent(event.getPlayer(), (NonNullConsumer<TitlesCapability>)((NonNullConsumer)newCap -> newCap.deserializeNBT(oldCap.serializeNBT())))));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> TitlesNetwork.toPlayer(new PacketSyncTitlesCapability(cap.serializeNBT()), (ServerPlayer)player)));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> TitlesNetwork.toPlayer(new PacketSyncTitlesCapability(cap.serializeNBT()), (ServerPlayer)player)));
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            TitlesNetwork.toPlayer(new PacketSyncDatapack(), event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                TitlesNetwork.toPlayer(new PacketSyncDatapack(), player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer playerLoggingIn = (ServerPlayer)event.getPlayer();
        TitleManager.doIfPresent((Player)playerLoggingIn, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            TitlesNetwork.toPlayer(new PacketSyncTitlesCapability(cap.serializeNBT()), playerLoggingIn);
            TitlesNetwork.toPlayer(new PacketSyncAllDisplayTitles(CommonEventHandler.getAllDisplayTitles((Player)playerLoggingIn)), playerLoggingIn);
            TitlesNetwork.toAll(new PacketSyncDisplayTitle(playerLoggingIn.m_142081_(), cap.getDisplayTitle().getID()));
        }));
    }

    private static Map<UUID, ResourceLocation> getAllDisplayTitles(Player player) {
        HashMap<UUID, ResourceLocation> allSelectedTitles = new HashMap<UUID, ResourceLocation>();
        for (ServerPlayer serverPlayer : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (serverPlayer.m_142081_() == player.m_142081_()) continue;
            TitleManager.doIfPresent((Player)serverPlayer, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> allSelectedTitles.put(serverPlayer.m_142081_(), cap.getDisplayTitle().getID())));
        }
        return allSelectedTitles;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerNameFormat(PlayerEvent.NameFormat event) {
        Player player = event.getPlayer();
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> event.setDisplayname((Component)TitleManager.getFormattedDisplayName(cap.getDisplayTitle(), player, cap))));
    }
}

