/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.init.ModTags;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="titles")
public class AdvancementEventHandler {
    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        Advancement advancement = event.getAdvancement();
        TitleManager.unlockTitle((ServerPlayer)event.getPlayer(), advancement.m_138327_());
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        if (event.getSource().f_19326_.equals("arrow") && target.m_21234_() >= 7) {
            AdvancementEventHandler.grantCriterion((ServerPlayer)target, "pincushion");
        } else if (event.getSource() == DamageSource.f_146701_) {
            TitlesMod.LOG.info("(AdvancementHandler) Do we at least get here?");
            AdvancementEventHandler.grantCriterion((ServerPlayer)target, "frigid");
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Entity player = event.getEntity();
        if (player instanceof ServerPlayer) {
            Block block = Block.m_49814_((Item)event.getTo().m_41720_());
            EquipmentSlot slot = event.getSlot();
            if (block == Blocks.f_50143_ && slot == EquipmentSlot.HEAD) {
                AdvancementEventHandler.grantCriterion((ServerPlayer)player, "melon_lord");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mounting = event.getEntityMounting();
        if (mounting instanceof ServerPlayer && event.getEntityBeingMounted() instanceof Boat) {
            AdvancementEventHandler.grantCriterion((ServerPlayer)mounting, "captain");
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        boolean beaconBaseAndOpulent;
        Block placedBlock = event.getPlacedBlock().m_60734_();
        Entity player = event.getEntity();
        boolean bl = beaconBaseAndOpulent = placedBlock.m_49966_().m_204336_(ModTags.Blocks.OPULENT) && placedBlock.m_49966_().m_204336_(BlockTags.f_13079_);
        if (!(player instanceof ServerPlayer) || placedBlock != Blocks.f_50273_ && !beaconBaseAndOpulent) {
            return;
        }
        if (AdvancementEventHandler.verifyBeaconLevelAndComposition(event.getPos(), player.f_19853_, placedBlock)) {
            AdvancementEventHandler.grantCriterion((ServerPlayer)player, "opulent");
        }
    }

    private static boolean verifyBeaconLevelAndComposition(BlockPos placedPos, Level world, Block placedBlock) {
        int j;
        BlockPos beaconBlockPos = AdvancementEventHandler.findBeacon(placedPos, world, placedBlock);
        if (beaconBlockPos == null) {
            return false;
        }
        boolean onlyOpulentBlock = true;
        int levels = 0;
        int i = 1;
        block0: while (i <= 4 && (j = beaconBlockPos.m_123342_() - i) >= 0) {
            for (int k = beaconBlockPos.m_123341_() - i; k <= beaconBlockPos.m_123341_() + i; ++k) {
                for (int l = beaconBlockPos.m_123343_() - i; l <= beaconBlockPos.m_123343_() + i; ++l) {
                    if (world.m_8055_(new BlockPos(k, j, l)).m_60734_() == placedBlock) continue;
                    onlyOpulentBlock = false;
                    break block0;
                }
            }
            levels = i++;
        }
        return onlyOpulentBlock && levels == 4;
    }

    private static BlockPos findBeacon(BlockPos placedPos, Level world, Block placedBlock) {
        if (placedBlock == Blocks.f_50273_) {
            return placedPos;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = 0; y <= 4; ++y) {
                    BlockPos tempPos = placedPos.m_142082_(x, y, z);
                    if (world.m_8055_(tempPos).m_60734_() != Blocks.f_50273_) continue;
                    return tempPos;
                }
            }
        }
        return null;
    }

    private static void grantCriterion(ServerPlayer player, String advancementId) {
        PlayerAdvancements advancements = player.m_8960_();
        ServerAdvancementManager manager = player.m_183503_().m_142572_().m_129889_();
        Advancement advancement = manager.m_136041_(TitlesMod.prefix(advancementId));
        if (advancement != null) {
            advancements.m_135988_(advancement, "code_triggered");
        }
    }
}

