/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.data;

import aurilux.titles.client.Keybinds;
import aurilux.titles.common.init.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class LangGenerator
extends LanguageProvider {
    public LangGenerator(DataGenerator gen) {
        super(gen, "titles", "en_us");
    }

    protected void addTranslations() {
        String keyPath = "";
        this.add("chat.advancement.append", " and earned the title [%s]");
        this.add("chat.scroll.success", "The scroll reveals a the new title [%s]");
        this.add("chat.scroll.fail", "The scroll reveals no new titles");
        this.add("commands.titles.usage", "/titles <add|remove> <player> <titleKey>");
        this.add("commands.titles.addremove.fail", "This command failed for an unknown reason");
        this.add("commands.titles.add", "Added title [%s] to player %s.");
        this.add("commands.titles.remove", "Removed title [%s] from player %s.");
        this.add("commands.display.success", "Changed your display title to [%s]");
        this.add("commands.nickname.success", "Nickname changed to [%s]");
        this.add("commands.nickname.empty", "Nickname reset!");
        this.add("commands.nickname.error.pattern", "Nickname must be 3-16 characters long, and include only the characters [a-zA-Z0-9_]");
        this.add(Keybinds.openTitleSelection.m_90858_(), "titles");
        this.add(Keybinds.openTitleSelection.m_90860_(), "Open Title Selection Screen");
        keyPath = String.format("gui.%s.", "titles");
        this.add(keyPath + "cancel", "Cancel");
        this.add(keyPath + "confirm", "Confirm");
        this.add(keyPath + "random", "Random");
        this.add(keyPath + "none", "None");
        this.add(keyPath + "purchase", "Purchase");
        this.add(keyPath + "close", "Close");
        this.add(keyPath + "titleselection.empty", "Unlock advancements to earn titles");
        this.add(keyPath + "titleselection.empty.filter", "Your filter has returned no results");
        this.add("itemGroup.titles", "titles");
        this.add((Item)ModItems.TITLE_FRAGMENT.get(), "Title Fragment");
        this.add((Item)ModItems.TITLE_SCROLL_COMMON.get(), "Common Title Scroll");
        this.add((Item)ModItems.TITLE_SCROLL_UNCOMMON.get(), "Uncommon Title Scroll");
        this.add((Item)ModItems.TITLE_SCROLL_RARE.get(), "Rare Title Scroll");
        keyPath = String.format("advancement.%s.", "titles");
        this.add(keyPath + "root.desc", "Flaunt your Feats");
        this.addAdvancement(keyPath + "spelunker", "How Low Can You Go?", "Go below y-level 20");
        this.addAdvancement(keyPath + "chicken_chaser", "Do you Chase Chickens?", "Kill a chicken");
        this.addAdvancement(keyPath + "captain", "You are the Captain Now", "Get in a boat");
        this.addAdvancement(keyPath + "melon_lord", "MWAHAHAHA", "Wear a carved pumpkin as a helmet");
        this.addAdvancement(keyPath + "pincushion", "Ouch... ouch...", "Have 7 arrows sticking out of you");
        this.addAdvancement(keyPath + "opulent", "The One Percent", "Build a beacon base entirely out of one type of expensive block");
        this.addAdvancement(keyPath + "frigid", "Ice Age", "Take freeze damage from being in Powder Snow");
        keyPath = String.format("title.%s.", "titles");
        this.add(keyPath + "spelunker", "Spelunker");
        this.addTitle(keyPath + "chicken_chaser", "the Chicken Chaser", "", "Good Cluck!");
        this.add(keyPath + "captain", "Captain");
        this.addTitle(keyPath + "opulent", "the Opulent", "", "How much can it cost? Like five dollars?");
        this.addTitle(keyPath + "melon_lord", "the Melon Lord", "", "I am not Toph! I am MELON LORD!");
        this.add(keyPath + "pincushion", "Pincushion");
        this.addTitle(keyPath + "frigid", "the Frigid", "", "Brrrrr!");
        this.minecraftTemplateTitles(keyPath);
        this.botaniaTemplateTitles(keyPath);
        this.IETemplateTitles(keyPath);
        this.TFTemplateTitles(keyPath);
    }

    private void TFTemplateTitles(String keyPath) {
        String twilightKeyPath = keyPath + "twilightforest.";
        this.add(twilightKeyPath + "quest_ram", "the Multicolored");
        this.add(twilightKeyPath + "troll", "Troll Slayer");
        this.add(twilightKeyPath + "giants", "Giant Slayer");
        this.add(twilightKeyPath + "kill_naga", "Naga Slayer");
        this.add(twilightKeyPath + "kill_lich", "Lich Slayer");
        this.addTitle(twilightKeyPath + "progress_glacier", "Queen Slayer", "", "Jaime Lannister would be proud.");
        this.add(twilightKeyPath + "full_mettle_alchemist", "the Resilient");
        this.add(twilightKeyPath + "mazebreaker", "Vault Breaker");
        this.add(twilightKeyPath + "fiery_set", "the Flame-forged");
    }

    private void IETemplateTitles(String keyPath) {
        String immersiveKeyPath = keyPath + "immersiveengineering.main.";
        this.add(immersiveKeyPath + "connect_wire", "the Live Wire");
        this.add(immersiveKeyPath + "craft_workbench", "Tinkerer");
        this.addTitle(immersiveKeyPath + "place_windmill", "the Tilted", "", "Perhaps to be too practical is madness.");
        this.add(immersiveKeyPath + "mb_fermenter", "the Bootlegger");
        this.add(immersiveKeyPath + "secret_luckofthedraw", "Gambler");
        this.add(immersiveKeyPath + "secret_birthdayparty", "Party Popper");
        this.addTitle(immersiveKeyPath + "secret_drillbreak", "the Heaven Piercer", "", "Let me see you grit those teeth!");
        this.add(immersiveKeyPath + "mb_excavator", "Quarrier");
    }

    private void botaniaTemplateTitles(String keyPath) {
        String botaniaKeyPath = keyPath + "botania.main.";
        this.add(botaniaKeyPath + "flower_pickup", "Flower Picker");
        this.addTitle(botaniaKeyPath + "cacophonium_craft", "the Noisy", "", "Let me play you the song of my people.");
        this.add(botaniaKeyPath + "rune_pickup", "the Runechild");
        this.add(botaniaKeyPath + "tiny_potato_pet", "Spud Bud");
        this.add(botaniaKeyPath + "pollidisiac_pickup", "Matchmaker");
        this.add(botaniaKeyPath + "manaweave_armor_craft", "Manaweaver");
        this.add(botaniaKeyPath + "spark_craft", "the Sparkling");
        this.add(botaniaKeyPath + "elf_portal_open", "the Midgardian Trader");
        this.add(botaniaKeyPath + "heisei_dream_pickup", "the Maddening");
        this.addTitle(botaniaKeyPath + "dandelifeon_pickup", "Wheel Spinner", "", "Collect beaucoup bucks!");
        this.add(botaniaKeyPath + "luminizer_ride", "Light Treader");
        botaniaKeyPath = keyPath + "botania.challenge.";
        this.add(botaniaKeyPath + "gaia_guardian_hardmode", "Gaia Slayer");
        this.add(botaniaKeyPath + "gaia_guardian_no_armor", "the Exhibitionist");
        this.addTitle(botaniaKeyPath + "alf_portal_bread", "the Midgardian Baker", "", "WHAT IS YOUR PROFESSION?!");
        this.add(botaniaKeyPath + "super_corporea_request", "Stockpiler");
        this.add(botaniaKeyPath + "rank_ss_pick", "World Breaker");
        this.add(botaniaKeyPath + "pinkinator", "the Rosy");
        this.add(botaniaKeyPath + "king_key", "the Babylonian");
    }

    private void minecraftTemplateTitles(String keyPath) {
        String minecraftKeyPath = keyPath + "minecraft.story.";
        this.add(minecraftKeyPath + "iron_tools", "Miner");
        this.addTitle(minecraftKeyPath + "obtain_armor", "Armorer", "", "This is the Way.");
        this.addTitle(minecraftKeyPath + "deflect_arrow", "Shield Bearer", "Shield Maiden", "As you wish, my Thane.");
        this.addTitle(minecraftKeyPath + "enchant_item", "the Enchanter", "the Enchantress", "");
        this.add(minecraftKeyPath + "cure_zombie_villager", "Purifier");
        this.addTitle(minecraftKeyPath + "enter_the_end", "the Puddle Jumper", "", "Flight, this is... Puddle Jumper.");
        minecraftKeyPath = keyPath + "minecraft.husbandry.";
        this.add(minecraftKeyPath + "breed_an_animal", "Rancher");
        this.add(minecraftKeyPath + "fishy_business", "Fisherman");
        this.add(minecraftKeyPath + "make_a_sign_glow", "the Glowing");
        this.add(minecraftKeyPath + "bred_all_animals", "Shepherd");
        this.add(minecraftKeyPath + "complete_catalogue", "the Ailurophile");
        this.add(minecraftKeyPath + "balanced_diet", "the Epicure");
        this.add(minecraftKeyPath + "obtain_netherite_hoe", "the Green Thumb");
        minecraftKeyPath = keyPath + "minecraft.adventure.";
        this.addTitle(minecraftKeyPath + "kill_a_mob", "Huntsman", "Huntress", "");
        this.add(minecraftKeyPath + "spyglass_at_parrot", "the Onlooker");
        this.add(minecraftKeyPath + "trade", "Haggler");
        this.add(minecraftKeyPath + "shoot_arrow", "Bowman");
        this.add(minecraftKeyPath + "fall_from_world_height", "the Base Jumper");
        this.add(minecraftKeyPath + "lightning_rod_with_villager_no_fire", "the Shocking");
        this.add(minecraftKeyPath + "kill_all_mobs", "Predator");
        this.add(minecraftKeyPath + "totem_of_undying", "the Deathless");
        this.add(minecraftKeyPath + "summon_iron_golem", "the Samaritan");
        this.add(minecraftKeyPath + "two_birds_one_arrow", "the Opportunist");
        this.add(minecraftKeyPath + "arbalistic", "the Patient");
        this.add(minecraftKeyPath + "adventuring_time", "the Globetrotter");
        this.add(minecraftKeyPath + "hero_of_the_village", "Defender");
        this.add(minecraftKeyPath + "spyglass_at_ghast", "the Watcher");
        this.add(minecraftKeyPath + "walk_on_powder_snow_with_leather_boots", "the Light-footed");
        this.add(minecraftKeyPath + "spyglass_at_dragon", "the Beholder");
        this.add(minecraftKeyPath + "sniper_duel", "Marksman");
        this.add(minecraftKeyPath + "bullseye", "the Unerring");
        minecraftKeyPath = keyPath + "minecraft.nether.";
        this.add(minecraftKeyPath + "return_to_sender", "the Mailman");
        this.add(minecraftKeyPath + "fast_travel", "the Expeditious");
        this.add(minecraftKeyPath + "obtain_crying_obsidian", "the Tear Jerker");
        this.add(minecraftKeyPath + "ride_strider", "the Strider Rider");
        this.add(minecraftKeyPath + "uneasy_alliance", "the Merciful");
        this.add(minecraftKeyPath + "loot_bastion", "Raider");
        this.add(minecraftKeyPath + "netherite_armor", "the Emblazoned");
        this.add(minecraftKeyPath + "charge_respawn_anchor", "the Prepared");
        this.add(minecraftKeyPath + "explore_nether", "Trailblazer");
        this.add(minecraftKeyPath + "brew_potion", "Brewer");
        this.add(minecraftKeyPath + "all_potions", "the Alchemist");
        this.add(minecraftKeyPath + "all_effects", "the Overloaded");
        this.add(minecraftKeyPath + "create_full_beacon", "the Architect");
        minecraftKeyPath = keyPath + "minecraft.end.";
        this.add(minecraftKeyPath + "kill_dragon", "Liberator");
        this.add(minecraftKeyPath + "dragon_egg", "Caretaker");
        this.add(minecraftKeyPath + "respawn_dragon", "Reviver");
        this.addTitle(minecraftKeyPath + "dragon_breath", "the Breathtaking", "", "No, you're breathtaking!");
        this.addTitle(minecraftKeyPath + "elytra", "the Lightyear", "", "...it's falling with STYLE!");
        this.add(minecraftKeyPath + "levitate", "the Elevated");
    }

    private void addAdvancement(String path, String name, String description) {
        this.add(path, name);
        this.add(path + ".desc", description);
    }

    private void addTitle(String path, String name, String variant, String flavor) {
        this.add(path, name);
        if (!StringUtil.m_14408_((String)variant)) {
            this.add(path + ".variant", variant);
        }
        if (!StringUtil.m_14408_((String)flavor)) {
            this.add(path + ".flavor", flavor);
        }
    }
}

