/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.core;

import aurilux.titles.api.Title;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TitlesCapability {
    public static final Capability<TitlesCapability> TITLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TitlesCapability>(){});
    public static final ResourceLocation NAME = TitlesMod.prefix("titles");
    private final String GENDER_SETTING = "gender_setting";
    private final String DISPLAY_TITLE = "display_title";
    private final String OBTAINED_TITLES = "obtained_titles";
    private final String NICKNAME = "nickname";
    private final Set<Title> obtainedTitles = new HashSet<Title>();
    private String nickname = "";
    private Title displayTitle = Title.NULL_TITLE;
    private boolean genderSetting = true;

    public boolean add(Title title) {
        return !title.isNull() && this.obtainedTitles.add(title);
    }

    public void remove(Title title) {
        this.obtainedTitles.remove(title);
    }

    public void setNickname(String newNickname) {
        this.nickname = newNickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Set<Title> getObtainedTitles() {
        return this.obtainedTitles;
    }

    public void setDisplayTitle(Title newTitle) {
        this.displayTitle = newTitle;
    }

    public Title getDisplayTitle() {
        return this.displayTitle;
    }

    public boolean getGenderSetting() {
        return this.genderSetting;
    }

    public void setGenderSetting(boolean newSetting) {
        this.genderSetting = newSetting;
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        data.m_128359_("nickname", this.nickname);
        data.m_128379_("gender_setting", this.genderSetting);
        data.m_128359_("display_title", this.getDisplayTitle().getID().toString());
        ListTag obtained = new ListTag();
        for (Title title : this.obtainedTitles) {
            obtained.add((Object)StringTag.m_129297_((String)title.getID().toString()));
        }
        data.m_128365_("obtained_titles", (Tag)obtained);
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.obtainedTitles.clear();
        this.nickname = nbt.m_128461_("nickname");
        this.genderSetting = nbt.m_128471_("gender_setting");
        this.displayTitle = TitleManager.getTitle(nbt.m_128461_("display_title"));
        ListTag obtained = (ListTag)nbt.m_128423_("obtained_titles");
        for (int i = 0; i < obtained.size(); ++i) {
            Title title = TitleManager.getTitle(obtained.m_128778_(i));
            this.add(title);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        protected final TitlesCapability capInstance = new TitlesCapability();
        protected final LazyOptional<TitlesCapability> capOptional = LazyOptional.of(() -> this.capInstance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == TITLES_CAPABILITY) {
                return this.capOptional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capInstance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capInstance.deserializeNBT(nbt);
        }
    }
}

