/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.core;

import aurilux.titles.api.Title;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.network.messages.PacketSyncDatapack;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class TitleRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, Title> titles = new HashMap<ResourceLocation, Title>();
    private final Map<ResourceLocation, Title> contributorTitles = new HashMap<ResourceLocation, Title>();
    private static final TitleRegistry INSTANCE = new TitleRegistry();

    private TitleRegistry() {
        super(GSON, "titles");
    }

    public static TitleRegistry get() {
        return INSTANCE;
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataFromMods, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        profilerIn.m_6180_("titleLoader");
        Set<String> modsWithNativeTitles = this.determineModsWithNativeTitles();
        TitlesMod.LOG.debug("Mods with native titles: {}", Arrays.asList(modsWithNativeTitles.toArray()));
        dataFromMods.forEach((location, element) -> {
            try {
                ResourceLocation processedLocation = this.processTemplateResource((ResourceLocation)location, modsWithNativeTitles);
                Title title = this.loadTitle(processedLocation, element.getAsJsonObject());
                this.titles.put(processedLocation, title);
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                TitlesMod.LOG.error("Parsing error loading title {}: {}", location, (Object)ex.getMessage());
            }
        });
        TitlesMod.LOG.debug("Loaded {} titles", (Object)this.titles.size());
        this.titles.putAll(this.contributorTitles);
        profilerIn.m_7238_();
    }

    private Set<String> determineModsWithNativeTitles() {
        HashSet<String> set = new HashSet<String>();
        for (IModInfo modInfo : ModList.get().getMods()) {
            Path modTitlesPath;
            String modId = modInfo.getModId();
            if (modId.equals("minecraft") || modId.equals("forge") || modId.equals("titles") || !Files.exists(modTitlesPath = modInfo.getOwningFile().getFile().findResource(new String[]{String.format("data/%s/%s", modId, "titles")}), new LinkOption[0])) continue;
            set.add(modId);
        }
        return set;
    }

    private ResourceLocation processTemplateResource(ResourceLocation location, Set<String> modsWithTitles) {
        boolean isTemplate;
        String path = location.m_135815_();
        boolean bl = isTemplate = location.m_135827_().equals("titles") && path.startsWith("_");
        if (!isTemplate) {
            return location;
        }
        int slashIndex = path.indexOf("/");
        String possibleModId = path.substring(1, slashIndex);
        if (!modsWithTitles.contains(possibleModId)) {
            String trimmedPath = path.substring(slashIndex + 1);
            return new ResourceLocation(possibleModId, trimmedPath);
        }
        return location;
    }

    public Title loadTitle(ResourceLocation res, JsonObject json) {
        json.addProperty("id", res.toString());
        Title.Builder builder = Title.Builder.deserialize(json);
        Rarity rarityRef = builder.getRarity();
        if (rarityRef.equals((Object)Rarity.EPIC)) {
            builder.rarity(Rarity.COMMON);
        }
        return builder.build();
    }

    public Map<ResourceLocation, Title> getTitles() {
        return new HashMap<ResourceLocation, Title>(this.titles);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processServerData(PacketSyncDatapack msg) {
        this.titles.clear();
        this.titles.putAll(msg.getAllLoadedTitles());
        TitlesMod.LOG.debug("Synced {} titles from server", (Object)this.titles.size());
    }

    public void loadContributors() {
        Thread thread = new Thread(this::fetchContributors);
        thread.setName("Titles Contributor Title Thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(TitlesMod.LOG));
        thread.start();
    }

    private void fetchContributors() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Aurilux/Titles/master/contributors.properties");
            Properties props = new Properties();
            InputStreamReader reader = new InputStreamReader(url.openStream());
            props.load(reader);
            this.createContributorTitles(props);
        }
        catch (IOException e) {
            TitlesMod.LOG.info("Unable to load contributors list. Most likely you're offline or github is down.");
        }
    }

    private void createContributorTitles(Properties props) {
        Title.Builder contributorBuilder = Title.Builder.create("titles").type(Title.AwardType.CONTRIBUTOR).rarity(Rarity.EPIC);
        for (String contributorName : props.stringPropertyNames()) {
            String contributorTitle = props.getProperty(contributorName);
            contributorBuilder.id(TitlesMod.prefix(contributorName.toLowerCase(Locale.ROOT))).defaultDisplay(contributorTitle);
            Title title = contributorBuilder.build();
            this.contributorTitles.put(title.getID(), title);
        }
        TitlesMod.LOG.info("Loaded {} contributor titles", (Object)this.contributorTitles.size());
    }
}

