/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.core;

import aurilux.titles.api.Title;
import aurilux.titles.common.core.TitleRegistry;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncUnlockedTitle;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class TitleManager {
    public static void unlockTitle(ServerPlayer player, ResourceLocation titleKey) {
        TitleManager.doIfPresent((Player)player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            if (cap.add(TitleManager.getTitle(titleKey))) {
                TitlesNetwork.toPlayer(new PacketSyncUnlockedTitle(titleKey), player);
            }
        }));
    }

    public static Map<ResourceLocation, Title> getTitlesOfType(Title.AwardType awardType) {
        return TitleRegistry.get().getTitles().entrySet().stream().filter(entry -> ((Title)entry.getValue()).getType().equals((Object)awardType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void setDisplayTitle(Player player, ResourceLocation id) {
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            cap.setDisplayTitle(TitleManager.getTitle(id));
            player.refreshDisplayName();
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).refreshTabListName();
            }
        }));
    }

    public static void setNickname(Player player, String nickname) {
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            cap.setNickname(nickname);
            player.refreshDisplayName();
        }));
    }

    public static Title getTitle(String id) {
        return TitleManager.getTitle(new ResourceLocation(id));
    }

    public static Title getTitle(ResourceLocation id) {
        return TitleRegistry.get().getTitles().getOrDefault(id, Title.NULL_TITLE);
    }

    public static void doIfPresent(Player player, NonNullConsumer<TitlesCapability> toDo) {
        TitleManager.getCapability(player).ifPresent(toDo);
    }

    public static LazyOptional<TitlesCapability> getCapability(Player player) {
        return player.getCapability(TitlesCapability.TITLES_CAPABILITY);
    }

    public static MutableComponent getFormattedDisplayName(Title title, Player player, TitlesCapability cap) {
        return TitleManager.getFormattedDisplayName(title, player, cap, cap.getGenderSetting());
    }

    public static MutableComponent getFormattedDisplayName(Title title, Player player, TitlesCapability cap, boolean genderSetting) {
        Component playerName;
        MutableComponent titleComponent = title.getTextComponent(genderSetting);
        Object object = playerName = cap.getNickname().isEmpty() ? player.m_7755_() : new TextComponent(cap.getNickname());
        if (title.isNull()) {
            return playerName.m_6881_();
        }
        if (title.isPrefix()) {
            return new TextComponent("").m_7220_((Component)titleComponent).m_130946_(" ").m_7220_((Component)playerName.m_6881_());
        }
        return playerName.m_6881_().m_130946_(", ").m_7220_((Component)titleComponent);
    }
}

