/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.sub;

import aurilux.titles.api.Title;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncTitlesCapability;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullConsumer;

public class CommandRefresh {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"refresh").executes(CommandRefresh::run);
    }

    private static int run(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TitleManager.doIfPresent((Player)player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
                TitleManager.setDisplayTitle((Player)player, Title.NULL_TITLE.getID());
                cap.getObtainedTitles().removeIf(t -> t.getType().equals((Object)Title.AwardType.ADVANCEMENT));
                PlayerAdvancements playerAdvancements = player.m_8960_();
                Collection allAdvancements = ((CommandSourceStack)context.getSource()).m_81377_().m_129889_().m_136028_();
                allAdvancements = allAdvancements.stream().filter(advancement -> playerAdvancements.m_135996_(advancement).m_8193_() && !TitleManager.getTitle(advancement.m_138327_()).isNull()).collect(Collectors.toCollection(ArrayList::new));
                allAdvancements.forEach(advancement -> {
                    TitlesMod.LOG.debug("Re-awarding title for advancement {}", (Object)advancement.m_138327_());
                    cap.add(TitleManager.getTitle(advancement.m_138327_()));
                });
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Finished refreshing advancement titles!"), true);
                TitlesNetwork.toPlayer(new PacketSyncTitlesCapability(cap.serializeNBT()), player);
            }));
        }
        catch (CommandSyntaxException ex) {
            TitlesMod.LOG.warn("Exception in titles command: refresh. {}", (Object)ex.getMessage());
        }
        return 1;
    }
}

