/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.sub;

import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.core.TitlesConfig;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncNickname;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullConsumer;

public class CommandNickname {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nickname").requires(s -> (Boolean)TitlesConfig.COMMON.nickname.get())).executes(ctx -> CommandNickname.run((CommandContext<CommandSourceStack>)ctx, ""))).then(Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandNickname.run((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"nickname"))));
    }

    private static int run(CommandContext<CommandSourceStack> ctx, String nickname) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            TranslatableComponent feedback = new TranslatableComponent("commands.nickname.success", new Object[]{nickname});
            if (nickname.isEmpty()) {
                feedback = new TranslatableComponent("commands.nickname.empty", new Object[]{nickname});
            } else if (!Pattern.matches("^[a-zA-Z0-9_]{3,16}$", nickname)) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.nickname.error.pattern", new Object[]{nickname}).m_130940_(ChatFormatting.RED), true);
                return 0;
            }
            TitleManager.doIfPresent((Player)player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
                TitleManager.setNickname((Player)player, nickname);
                TitlesNetwork.toAll(new PacketSyncNickname(player.m_142081_(), nickname));
            }));
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)feedback, true);
        }
        catch (CommandSyntaxException ex) {
            TitlesMod.LOG.warn("Exception in titles command: nickname. {}", (Object)ex.getMessage());
        }
        return 1;
    }
}

