/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.sub;

import aurilux.titles.api.Title;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.command.argument.TitleArgument;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullConsumer;

public class CommandDisplay {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"display").then(Commands.m_82129_((String)"title", (ArgumentType)TitleArgument.display()).executes(ctx -> CommandDisplay.run((CommandContext<CommandSourceStack>)ctx, TitleArgument.getTitle(ctx, "title"))));
    }

    private static int run(CommandContext<CommandSourceStack> ctx, Title title) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            TitleManager.doIfPresent((Player)player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
                TitleManager.setDisplayTitle((Player)player, title.getID());
                TitlesNetwork.toAll(new PacketSyncDisplayTitle(player.m_142081_(), title.getID()));
                TranslatableComponent feedback = new TranslatableComponent("commands.display.success", new Object[]{title.getTextComponent(cap.getGenderSetting())});
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)feedback, true);
            }));
        }
        catch (CommandSyntaxException ex) {
            TitlesMod.LOG.warn("Exception in titles command: display. {}", (Object)ex.getMessage());
        }
        return 1;
    }
}

