/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.sub;

import aurilux.titles.api.Title;
import aurilux.titles.common.command.argument.TitleArgument;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncTitlesCapability;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.server.command.EnumArgument;

public class CommandAddRemove {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((RequiredArgumentBuilder)Commands.m_82129_((String)"command", (ArgumentType)EnumArgument.enumArgument(CommandType.class)).requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"title", (ArgumentType)TitleArgument.any()).executes(ctx -> CommandAddRemove.run((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), TitleArgument.getTitle(ctx, "title")))));
    }

    private static int run(CommandContext<CommandSourceStack> context, ServerPlayer player, Title title) {
        CommandType commandType = (CommandType)((Object)context.getArgument("command", CommandType.class));
        BaseComponent[] response = new BaseComponent[]{new TranslatableComponent("commands.titles.addremove.fail")};
        TitleManager.doIfPresent((Player)player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            MutableComponent formattedTitle = title.getTextComponent(cap.getGenderSetting());
            if (title.getType().equals((Object)Title.AwardType.CONTRIBUTOR)) {
                return;
            }
            if (commandType.equals((Object)CommandType.add)) {
                cap.add(title);
                response[0] = new TranslatableComponent("commands.titles.add", new Object[]{formattedTitle, player.m_7755_()});
            } else if (commandType.equals((Object)CommandType.remove)) {
                cap.remove(title);
                response[0] = new TranslatableComponent("commands.titles.remove", new Object[]{formattedTitle, player.m_7755_()});
            }
            TitlesNetwork.toPlayer(new PacketSyncTitlesCapability(cap.serializeNBT()), player);
        }));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)response[0], false);
        return 1;
    }

    public static enum CommandType {
        remove,
        add;

    }
}

