/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.command.argument;

import aurilux.titles.api.Title;
import aurilux.titles.client.ClientOnlyMethods;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitleRegistry;
import aurilux.titles.common.core.TitlesCapability;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.DistExecutor;

public class TitleArgument
implements ArgumentType<Title> {
    private static final List<String> EXAMPLES = Arrays.asList("titles:captain", "titles:opulent", "titles:chicken_chaser");
    public static final Predicate<Title> ANY = t -> !t.getType().equals((Object)Title.AwardType.CONTRIBUTOR);
    public static final Predicate<Title> DISPLAY = t -> {
        boolean[] test = new boolean[]{false};
        Player player = (Player)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> ClientOnlyMethods::getPlayer);
        TitleManager.doIfPresent(player, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)cap -> {
            test[0] = TitlesMod.prefix(player.m_7755_().getString().toLowerCase()).equals((Object)t.getID()) || cap.getObtainedTitles().contains(t);
        }));
        return test[0];
    };
    private final Predicate<Title> predicate;

    private TitleArgument(Predicate<Title> p) {
        this.predicate = p;
    }

    public static TitleArgument any() {
        return new TitleArgument(ANY);
    }

    public static TitleArgument display() {
        return new TitleArgument(DISPLAY);
    }

    public Predicate<Title> getPredicate() {
        return this.predicate;
    }

    public Title parse(StringReader reader) throws CommandSyntaxException {
        return TitleManager.getTitle(ResourceLocation.m_135818_((StringReader)reader));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(TitleRegistry.get().getTitles().values().stream().filter(this.predicate).map(t -> t.getID().toString()), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static <S> Title getTitle(CommandContext<S> context, String name) {
        return (Title)context.getArgument(name, Title.class);
    }
}

