/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common;

import aurilux.titles.client.Keybinds;
import aurilux.titles.common.command.CommandTitles;
import aurilux.titles.common.command.argument.TitleArgument;
import aurilux.titles.common.command.argument.TitleArgumentSerializer;
import aurilux.titles.common.core.TitleRegistry;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.core.TitlesConfig;
import aurilux.titles.common.data.ItemModelGenerator;
import aurilux.titles.common.data.LangGenerator;
import aurilux.titles.common.data.TitlesGenerator;
import aurilux.titles.common.handler.ConfigEventHandler;
import aurilux.titles.common.init.ModItems;
import aurilux.titles.common.network.TitlesNetwork;
import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="titles")
public class TitlesMod {
    public static final String MOD_ID = "titles";
    public static final Logger LOG = LoggerFactory.getLogger((String)"titles".toUpperCase());
    public static final CreativeModeTab TAB = new CreativeModeTab("titles"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.TITLE_SCROLL_COMMON.get());
        }
    };

    public TitlesMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TitlesConfig.COMMON_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::registerCapabilities);
        ModItems.register(modBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(TitleRegistry::register);
        forgeBus.addListener(this::registerCommands);
        this.addConfigHandlers(modBus, forgeBus);
    }

    private void addConfigHandlers(IEventBus modBus, IEventBus forgeBus) {
        if (((Boolean)TitlesConfig.COMMON.fragmentLoot.get()).booleanValue()) {
            forgeBus.addListener(ConfigEventHandler::addLoot);
            forgeBus.addListener(ConfigEventHandler::onVillagerTrades);
        }
        if (((Boolean)TitlesConfig.SERVER.showInTablist.get()).booleanValue()) {
            forgeBus.addListener(ConfigEventHandler::onTabListNameFormat);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ArgumentTypes.m_121601_((String)"titles:title", TitleArgument.class, (ArgumentSerializer)new TitleArgumentSerializer());
        TitlesNetwork.init();
        TitleRegistry.get().loadContributors();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Keybinds.init();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new TitlesGenerator(gen));
        }
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new LangGenerator(gen));
            gen.m_123914_((DataProvider)new ItemModelGenerator(gen, fileHelper));
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandTitles.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(TitlesCapability.class);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

