/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.handler;

import aurilux.titles.api.Title;
import aurilux.titles.client.Keybinds;
import aurilux.titles.client.gui.TitleSelectionScreen;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(modid="titles", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Keybinds.openTitleSelection.m_90859_() && (player = Minecraft.m_91087_().f_91074_) != null) {
            TitleManager.getCapability((Player)player).ifPresent(arg_0 -> ClientEventHandler.lambda$onClientTick$0((Player)player, arg_0));
        }
    }

    @SubscribeEvent
    public static void onClientReceivedChat(ClientChatReceivedEvent event) {
        TranslatableComponent textComponent;
        MutableComponent component = event.getMessage().m_6879_();
        if (component instanceof TranslatableComponent && (textComponent = (TranslatableComponent)component).m_131328_().startsWith("chat.type.advancement.")) {
            Component targetPlayerName = (Component)((Component)textComponent.m_131329_()[0]).m_7360_().get(0);
            Component componentArg = (Component)((TranslatableComponent)textComponent.m_131329_()[1]).m_131329_()[0];
            if (componentArg instanceof TranslatableComponent) {
                Title unlockedTitle = ClientEventHandler.processKey(((TranslatableComponent)componentArg).m_131328_());
                LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
                if (!unlockedTitle.isNull() && clientPlayer != null) {
                    TitleManager.doIfPresent((Player)clientPlayer, (NonNullConsumer<TitlesCapability>)((NonNullConsumer)arg_0 -> ClientEventHandler.lambda$onClientReceivedChat$2(unlockedTitle, (Player)clientPlayer, targetPlayerName, component, event, arg_0)));
                }
            }
        }
    }

    private static Title processKey(String key) {
        List<String> keyParts = new ArrayList<String>(Arrays.asList(key.split("[/.:]")));
        TitlesMod.LOG.info(Arrays.toString(keyParts.toArray()));
        keyParts = keyParts.stream().filter(part -> !part.startsWith("advancement") && !part.equals("title") && !part.equals("name")).map(part -> {
            if (part.chars().anyMatch(Character::isUpperCase)) {
                ArrayList<String> words = new ArrayList<String>(Arrays.asList(part.split("(?=\\p{javaUpperCase})")));
                words.replaceAll(String::toLowerCase);
                return String.join((CharSequence)"_", words);
            }
            return part;
        }).collect(Collectors.toList());
        List<String> modList = ModList.get().getMods().stream().map(IModInfo::getModId).filter(id -> !id.equals("forge") && !id.equals("FML") && !id.equals("mcp")).toList();
        String possibleModId = "";
        for (String part2 : keyParts) {
            if (!modList.contains(part2)) continue;
            possibleModId = part2;
            break;
        }
        Object titleString = "";
        if (!possibleModId.equals("")) {
            keyParts.remove(possibleModId);
            titleString = possibleModId + ":" + String.join((CharSequence)"/", keyParts);
        } else {
            for (String modId : modList) {
                ResourceLocation testKey = new ResourceLocation(modId + ":" + String.join((CharSequence)"/", keyParts));
                if (!TitleManager.getTitlesOfType(Title.AwardType.ADVANCEMENT).containsKey(testKey)) continue;
                titleString = testKey.toString();
                break;
            }
        }
        return TitleManager.getTitle((String)titleString);
    }

    private static /* synthetic */ void lambda$onClientReceivedChat$2(Title unlockedTitle, Player clientPlayer, Component targetPlayerName, MutableComponent component, ClientChatReceivedEvent event, TitlesCapability cap) {
        MutableComponent formattedTitle = unlockedTitle.getTextComponent(cap.getGenderSetting());
        if (clientPlayer.m_7755_().getString().equals(targetPlayerName.m_6111_())) {
            formattedTitle.m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/titles display " + unlockedTitle.getID().toString())));
        }
        component.m_7220_((Component)new TranslatableComponent("chat.advancement.append", new Object[]{formattedTitle}));
        event.setMessage((Component)component);
    }

    private static /* synthetic */ void lambda$onClientTick$0(Player player, TitlesCapability cap) {
        Minecraft.m_91087_().m_91152_((Screen)new TitleSelectionScreen(player, cap));
    }
}

