/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.gui;

import aurilux.titles.api.Title;
import aurilux.titles.client.Keybinds;
import aurilux.titles.client.gui.button.SimpleButtonOverride;
import aurilux.titles.client.gui.button.TitleButton;
import aurilux.titles.client.gui.button.ToggleImageButton;
import aurilux.titles.common.TitlesMod;
import aurilux.titles.common.core.TitleManager;
import aurilux.titles.common.core.TitlesCapability;
import aurilux.titles.common.network.TitlesNetwork;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import aurilux.titles.common.network.messages.PacketSyncGenderSetting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TitleSelectionScreen
extends Screen {
    private final ResourceLocation bgTexture = TitlesMod.prefix("textures/gui/title_selection.png");
    private final Button.OnTooltip titleWithFlavorText = (button, matrixStack, mouseX, mouseY) -> {
        String titleButtonFlavorText = ((TitleButton)button).getTitle().getFlavorText();
        if (button.f_93623_ && !StringUtil.m_14408_((String)titleButtonFlavorText)) {
            this.m_96617_(matrixStack, this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent(titleButtonFlavorText), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
        }
    };
    private final int NUM_COLS = 2;
    private final int NUM_ROWS = 6;
    protected final int MAX_PER_PAGE = 12;
    protected int page;
    protected int maxPages;
    private final int xSize = 308;
    private final int ySize = 218;
    protected int guiLeft;
    protected int guiTop;
    protected final int buttonHeight = 20;
    protected int leftOffset;
    protected int buttonFirstRowStart;
    protected int buttonTitleRowStart;
    protected int buttonSecondRowStart;
    private final TitlesCapability cap;
    private final List<Button> backButtons = new ArrayList<Button>();
    private final List<Button> forwardButtons = new ArrayList<Button>();
    private final List<Button> titleButtons = new ArrayList<Button>();
    protected Player player;
    protected Title temporaryTitle;
    private boolean temporaryGender;
    protected List<Title> titlesListCache;
    protected List<Title> titlesListFiltered;
    private EditBox search;

    public TitleSelectionScreen(Player player, TitlesCapability capability) {
        super((Component)new TextComponent("Title Selection"));
        this.player = player;
        this.cap = capability;
        this.temporaryGender = this.cap.getGenderSetting();
        this.temporaryTitle = this.cap.getDisplayTitle();
        this.titlesListCache = new ArrayList<Title>(this.cap.getObtainedTitles());
        String playerName = player.m_7755_().getString();
        ResourceLocation contributorTitle = TitlesMod.prefix(playerName.toLowerCase());
        Title possibleContributor = TitleManager.getTitlesOfType(Title.AwardType.CONTRIBUTOR).getOrDefault(contributorTitle, Title.NULL_TITLE);
        if (!possibleContributor.isNull()) {
            this.titlesListCache.add(possibleContributor);
        }
        this.titlesListCache.sort(new Title.RarityComparator());
        this.titlesListFiltered = new ArrayList<Title>(this.titlesListCache);
    }

    public void m_7856_() {
        super.m_7856_();
        this.page = 1;
        this.updateMaxPages();
        this.guiLeft = (this.f_96543_ - 308) / 2;
        this.guiTop = (this.f_96544_ - 218) / 2 - 10;
        this.leftOffset = this.guiLeft + 34;
        this.buttonFirstRowStart = this.guiTop + 37;
        this.buttonTitleRowStart = this.buttonFirstRowStart + 23;
        this.buttonSecondRowStart = this.buttonTitleRowStart + 123;
        this.search = new EditBox(this.f_96547_, this.leftOffset + 65, this.buttonFirstRowStart + 1, 110, 18, (Component)new TextComponent("search"));
        this.m_142416_((GuiEventListener)this.search);
        this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset, this.buttonFirstRowStart, 60, 20, (Component)new TranslatableComponent("gui.titles.random"), button -> this.chooseRandomTitle()));
        this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 180, this.buttonFirstRowStart, 60, 20, (Component)new TranslatableComponent("gui.titles.none"), button -> {
            this.temporaryTitle = Title.NULL_TITLE;
        }));
        this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 45, this.buttonSecondRowStart, 60, 20, (Component)new TranslatableComponent("gui.titles.cancel"), button -> this.exitScreen(false)));
        this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 135, this.buttonSecondRowStart, 60, 20, (Component)new TranslatableComponent("gui.titles.confirm"), button -> this.exitScreen(true)));
        this.backButtons.add((Button)this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset, this.buttonSecondRowStart, 20, 20, Component.m_130674_((String)"<<"), button -> this.setPage(1))));
        this.backButtons.add((Button)this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 22, this.buttonSecondRowStart, 20, 20, Component.m_130674_((String)"<"), button -> this.setPage(this.page - 1))));
        this.forwardButtons.add((Button)this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 198, this.buttonSecondRowStart, 20, 20, Component.m_130674_((String)">"), button -> this.setPage(this.page + 1))));
        this.forwardButtons.add((Button)this.m_142416_((GuiEventListener)new SimpleButtonOverride(this.leftOffset + 220, this.buttonSecondRowStart, 20, 20, Component.m_130674_((String)">>"), button -> this.setPage(this.maxPages))));
        this.m_142416_((GuiEventListener)new ToggleImageButton(this.guiLeft + 3, this.buttonFirstRowStart, 20, 20, 200, 220, 20, this.bgTexture, 512, 512, button -> this.genderToggle((ToggleImageButton)button), this.temporaryGender));
        this.updateButtons();
    }

    private void updateMaxPages() {
        this.maxPages = Math.max(1, (int)Math.ceil((double)this.titlesListFiltered.size() / 12.0));
    }

    private void genderToggle(ToggleImageButton button) {
        button.toggle();
        this.temporaryGender = button.getValue();
        this.updateButtons();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.bgTexture);
        TitleSelectionScreen.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)308, (int)218, (int)512, (int)512);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        MutableComponent titledPlayerName = TitleManager.getFormattedDisplayName(this.temporaryTitle, this.player, this.cap, this.temporaryGender);
        TitleSelectionScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)titledPlayerName, (int)(this.f_96543_ / 2), (int)(this.guiTop + 17), (int)0xFFFFFF);
        TitleSelectionScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)String.format("%s/%s", this.page, this.maxPages), (int)(this.f_96543_ / 2), (int)(this.guiTop + 189), (int)0xFFFFFF);
        if (this.titlesListFiltered.size() == 0) {
            Object emptyText = "gui.titles.titleselection.empty";
            if (this.titlesListCache.size() > 0) {
                emptyText = (String)emptyText + ".filter";
            }
            TitleSelectionScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)emptyText, (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.guiTop + 109), (int)0xFFFFFF);
        }
    }

    protected void exitScreen(boolean update) {
        if (update) {
            TitlesNetwork.toServer(new PacketSyncDisplayTitle(this.player.m_142081_(), this.temporaryTitle.getID()));
        }
        TitlesNetwork.toServer(new PacketSyncGenderSetting(this.player.m_142081_(), this.temporaryGender));
        this.m_7379_();
    }

    public void m_96624_() {
        this.search.m_94120_();
        super.m_96624_();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.search.m_93696_()) {
            String s = this.search.m_94155_();
            if (super.m_7933_(keyCode, scanCode, modifiers) && !Objects.equals(s, this.search.m_94155_())) {
                this.parseSearch(this.search.m_94155_());
            }
            return true;
        }
        if (Keybinds.openTitleSelection.m_90832_(keyCode, scanCode) || this.getMinecraft().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.exitScreen(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.search.m_93696_()) {
            String s = this.search.m_94155_();
            if (this.search.m_5534_(codePoint, modifiers) && !Objects.equals(s, this.search.m_94155_())) {
                this.parseSearch(this.search.m_94155_());
            }
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void parseSearch(String searchText) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(searchText.toLowerCase().split("\\s")));
        String modFilter = "";
        String rarityFilter = "";
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            String part = (String)iter.next();
            if (part.startsWith("@") && modFilter.equals("")) {
                modFilter = part.substring(1);
                iter.remove();
            }
            if (!part.startsWith("#") || !rarityFilter.equals("")) continue;
            rarityFilter = part.substring(1);
            iter.remove();
        }
        String finalModFilter = modFilter;
        String finalRarityFilter = rarityFilter;
        this.titlesListFiltered = this.titlesListCache.stream().filter(t -> t.getModid().startsWith(finalModFilter)).filter(t -> {
            String rarityName = t.getRarity().name();
            for (String letter : finalRarityFilter.split("")) {
                if (!rarityName.startsWith(letter.toUpperCase())) continue;
                return true;
            }
            return false;
        }).filter(t -> {
            if (parts.size() < 1) {
                return true;
            }
            String titleString = t.getTextComponent(this.temporaryGender).getString().toLowerCase();
            for (String part : parts) {
                if (!titleString.contains(part)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        this.updateMaxPages();
        if (this.page > this.maxPages) {
            this.page = 1;
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        this.removeButtons(this.titleButtons);
        this.titleButtons.clear();
        int maxIndex = Math.min(this.page * 12, this.titlesListFiltered.size());
        if (this.page == 1) {
            this.backButtons.forEach(b -> {
                b.f_93623_ = false;
            });
        } else {
            this.backButtons.forEach(b -> {
                b.f_93623_ = true;
            });
        }
        if (maxIndex == this.titlesListFiltered.size()) {
            this.forwardButtons.forEach(b -> {
                b.f_93623_ = false;
            });
        } else {
            this.forwardButtons.forEach(b -> {
                b.f_93623_ = true;
            });
        }
        List<Title> titlesToDisplay = this.titlesListFiltered.subList((this.page - 1) * 12, maxIndex);
        int titleButtonWidth = 120;
        for (int i = 0; i < titlesToDisplay.size(); ++i) {
            int col = i % 2;
            int row = i / 2;
            int x = this.leftOffset + titleButtonWidth * col;
            int y = this.buttonTitleRowStart + row * 20;
            Button button = (Button)this.m_142416_((GuiEventListener)new TitleButton(x, y, titleButtonWidth, 20, titlesToDisplay.get(i), this.temporaryGender, b -> {
                this.temporaryTitle = ((TitleButton)b).getTitle();
            }, this.titleWithFlavorText));
            this.titleButtons.add(button);
        }
    }

    private void removeButtons(List<Button> list) {
        for (Button button : list) {
            this.m_169411_((GuiEventListener)button);
        }
    }

    private void setPage(int pageNum) {
        this.page = pageNum;
        this.updateButtons();
    }

    private void chooseRandomTitle() {
        this.temporaryTitle = this.titlesListFiltered.size() <= 0 ? Title.NULL_TITLE : this.titlesListFiltered.get(this.player.f_19853_.f_46441_.nextInt(this.titlesListFiltered.size()));
    }
}

