/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api;

import aurilux.titles.api.Title;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TitleProvider
implements DataProvider {
    private final Logger LOGGER = LogManager.getLogger();
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TitleProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        HashSet foundTitles = Sets.newHashSet();
        this.registerTitles(title -> {
            if (!foundTitles.add(title.getID())) {
                this.LOGGER.warn("Skipping duplicate title: {}", (Object)title.getID());
            } else {
                this.saveTitle(cache, (Title)title);
            }
        });
    }

    protected abstract void registerTitles(Consumer<Title> var1);

    private void saveTitle(HashCache cache, Title title) {
        Path outputFolder = this.generator.m_123916_();
        Path saveFile = outputFolder.resolve(String.format("data/%s/titles/%s.json", title.getID().m_135827_(), title.getID().m_135815_()));
        try {
            DataProvider.m_123920_((Gson)this.GSON, (HashCache)cache, (JsonElement)title.serialize(), (Path)saveFile);
        }
        catch (IOException ex) {
            this.LOGGER.warn("Unable to save title {}", (Object)saveFile, (Object)ex);
        }
    }

    public String m_6055_() {
        return "Titles Provider";
    }
}

