/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api;

import aurilux.titles.common.TitlesMod;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Rarity;

public class Title {
    public static final Title NULL_TITLE = new Title(Builder.create("titles").id(TitlesMod.prefix("null")));
    private final AwardType type;
    private final boolean isPrefix;
    private final ResourceLocation id;
    private final String modid;
    private final Rarity rarity;
    private final String defaultDisplay;
    private final MutableComponent defaultComponent;
    private final String variantDisplay;
    private final MutableComponent variantComponent;
    private final String flavorText;

    private Title(Builder builder) {
        this.type = builder.getType();
        this.isPrefix = builder.isPrefix();
        this.id = builder.getID();
        this.modid = builder.getModId();
        this.rarity = builder.getRarity();
        this.defaultDisplay = builder.getDefaultDisplay();
        this.defaultComponent = this.createComponent(this.defaultDisplay);
        this.variantDisplay = builder.getVariantDisplay();
        this.variantComponent = !StringUtil.m_14408_((String)this.variantDisplay) ? this.createComponent(this.variantDisplay) : null;
        this.flavorText = builder.getFlavorText();
    }

    private MutableComponent createComponent(String lang) {
        return new TranslatableComponent(lang).m_130940_(this.getRarity().equals((Object)Rarity.COMMON) ? ChatFormatting.GRAY : this.getRarity().f_43022_);
    }

    public AwardType getType() {
        return this.type;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public String getModid() {
        return this.modid;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public String getFlavorText() {
        return this.flavorText;
    }

    public boolean isNull() {
        return this.equals(NULL_TITLE);
    }

    private String getDefaultDisplay() {
        return this.defaultDisplay;
    }

    private String getVariantDisplay() {
        return this.variantDisplay;
    }

    public MutableComponent getTextComponent(boolean isMasculine) {
        if (!isMasculine && this.variantComponent != null) {
            return this.variantComponent;
        }
        return this.defaultComponent;
    }

    public String toString() {
        return String.format("(%s, %s)", this.getID(), this.getRarity());
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType().toString().toLowerCase());
        json.addProperty("isPrefix", Boolean.valueOf(this.isPrefix()));
        json.addProperty("id", this.getID().toString());
        json.addProperty("rarity", this.getRarity().toString().toLowerCase());
        json.addProperty("defaultDisplay", this.getDefaultDisplay());
        if (!StringUtil.m_14408_((String)this.getVariantDisplay())) {
            json.addProperty("variantDisplay", this.getVariantDisplay());
        }
        if (!StringUtil.m_14408_((String)this.getFlavorText())) {
            json.addProperty("flavorText", this.getFlavorText());
        }
        return json;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Title)) {
            return false;
        }
        Title temp = (Title)o;
        return this.getID().equals((Object)temp.id) && this.getRarity().equals((Object)temp.rarity);
    }

    public static class Builder {
        private AwardType type = AwardType.ADVANCEMENT;
        private boolean isPrefix = false;
        private Rarity rarity = Rarity.COMMON;
        private ResourceLocation id;
        private String modId;
        private String defaultDisplay = "Not Set";
        private String variantDisplay;
        private String flavorText;

        private Builder() {
        }

        public static Builder create(String modId) {
            return new Builder().modId(modId);
        }

        public static Builder deserialize(JsonObject json) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"id"));
            Builder builder = Builder.create(id.m_135827_()).type(AwardType.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"type").toUpperCase())).id(id).rarity(Rarity.valueOf((String)GsonHelper.m_13906_((JsonObject)json, (String)"rarity").toUpperCase()));
            if (json.has("isPrefix") && GsonHelper.m_13912_((JsonObject)json, (String)"isPrefix")) {
                builder.setPrefix();
            }
            builder.defaultDisplay(GsonHelper.m_13906_((JsonObject)json, (String)"defaultDisplay"));
            if (json.has("variantDisplay")) {
                builder.variantDisplay(GsonHelper.m_13906_((JsonObject)json, (String)"variantDisplay"));
            }
            if (json.has("flavorText")) {
                builder.flavorText(GsonHelper.m_13906_((JsonObject)json, (String)"flavorText"));
            }
            return builder;
        }

        public Builder modId(String m) {
            this.modId = m;
            return this;
        }

        public String getModId() {
            return this.modId;
        }

        public Builder rarity(Rarity r) {
            this.rarity = r;
            return this;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public Builder type(AwardType t) {
            this.type = t;
            return this;
        }

        public AwardType getType() {
            return this.type;
        }

        public boolean isPrefix() {
            return this.isPrefix;
        }

        public Builder setPrefix() {
            this.isPrefix = true;
            return this;
        }

        public Builder id(String s) {
            return this.id(TitlesMod.prefix(s));
        }

        public Builder id(ResourceLocation r) {
            this.id = r;
            return this;
        }

        public ResourceLocation getID() {
            return this.id;
        }

        public Builder defaultDisplay(String d) {
            this.defaultDisplay = d;
            return this;
        }

        public String getDefaultDisplay() {
            return this.defaultDisplay;
        }

        public Builder variantDisplay(String v) {
            this.variantDisplay = v;
            return this;
        }

        public String getVariantDisplay() {
            return this.variantDisplay;
        }

        public Builder flavorText(String f) {
            this.flavorText = f;
            return this;
        }

        public String getFlavorText() {
            return this.flavorText;
        }

        private void reset() {
            this.isPrefix = false;
            this.defaultDisplay = "Not Set";
            this.variantDisplay = null;
            this.flavorText = null;
        }

        public Title save(Consumer<Title> consumer) {
            Title title = this.build();
            consumer.accept(title);
            return title;
        }

        public Title build() {
            Title title = new Title(this);
            this.reset();
            return title;
        }
    }

    public static enum AwardType {
        ADVANCEMENT,
        COMMAND,
        CONTRIBUTOR,
        LOOT;

    }

    public static class RarityComparator
    implements Comparator<Title> {
        @Override
        public int compare(Title o1, Title o2) {
            if (o1.rarity.ordinal() > o2.rarity.ordinal()) {
                return 1;
            }
            if (o1.rarity.ordinal() < o2.rarity.ordinal()) {
                return -1;
            }
            return 0;
        }
    }
}

