/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields;

import com.tome.bettershields.BetterShieldItem;
import com.tome.bettershields.Config;
import com.tome.bettershields.ShieldRecipes;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="bettershields")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterShields {
    public static final String MODID = "bettershields";
    public static BetterShieldItem ironShield;
    public static BetterShieldItem goldShield;
    public static BetterShieldItem diamondShield;
    public static BetterShieldItem netheriteShield;

    public BetterShields() {
        new Config();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        ironShield = new BetterShieldItem("iron_shield", Config.ironDamageReduction, "forge:ingots/iron", (int)((Integer)Config.ironDurability.get()), false);
        goldShield = new BetterShieldItem("gold_shield", Config.goldDamageReduction, "forge:ingots/gold", (int)((Integer)Config.goldDurability.get()), false);
        diamondShield = new BetterShieldItem("diamond_shield", Config.diamondDamageReduction, "forge:gems/diamond", (int)((Integer)Config.diamondDurability.get()), false);
        netheriteShield = new BetterShieldItem("netherite_shield", Config.netheriteDamageReduction, "forge:ingots/netherite", (int)((Integer)Config.netheriteDurability.get()), true);
        registry.registerAll((IForgeRegistryEntry[])new Item[]{ironShield, goldShield, diamondShield, netheriteShield});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)((RecipeSerializer)ShieldRecipes.SERIALIZER.setRegistryName(new ResourceLocation(MODID, "shield_decoration"))));
    }

    public static Component getBlockingTextComponent() {
        return new TranslatableComponent("bettershields.shield_blocking").m_130940_(ChatFormatting.GRAY);
    }

    public static Component getDamageReductionTextComponent(int reduction) {
        return new TranslatableComponent("bettershields.shield_damage_reduction", new Object[]{reduction}).m_130940_(ChatFormatting.DARK_GREEN);
    }
}

