/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields;

import com.tome.bettershields.Config;
import com.tome.bettershields.client.ShieldTileEntityRenderer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="bettershields")
public class BetterShieldItem
extends ShieldItem {
    private Supplier<Integer> damageReduction;
    private LazyLoadedValue<Ingredient> repairMaterial;

    public BetterShieldItem(String registryName, ForgeConfigSpec.ConfigValue<Integer> damageReduction, String repairTag, int durability, boolean fireProof) {
        this(new ResourceLocation("bettershields", registryName), () -> damageReduction.get(), () -> BetterShieldItem.getTagIngredient(repairTag), durability, fireProof);
    }

    public BetterShieldItem(ResourceLocation registryName, Supplier<Integer> damageReduction, Supplier<Ingredient> repairMaterial, int durability, boolean fireProof) {
        super((fireProof ? new Item.Properties().m_41486_() : new Item.Properties()).m_41491_(CreativeModeTab.f_40757_).m_41503_(durability));
        this.setRegistryName(registryName);
        this.damageReduction = damageReduction;
        this.repairMaterial = new LazyLoadedValue(repairMaterial);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    private static Ingredient getTagIngredient(String name) {
        Ingredient ingredient = null;
        try {
            Method getAllTags = ObfuscationReflectionHelper.findMethod(ItemTags.class, (String)"m_13193_", (Class[])new Class[0]);
            Object allTags = getAllTags.invoke(null, new Object[0]);
            Class<?> TagCollection = Class.forName("net.minecraft.tags.TagCollection");
            Method getTag = ObfuscationReflectionHelper.findMethod(TagCollection, (String)"m_13404_", (Class[])new Class[]{ResourceLocation.class});
            Object tag = getTag.invoke(allTags, new ResourceLocation(name));
            Class<?> Tag = Class.forName("net.minecraft.tags.Tag");
            Method of = ObfuscationReflectionHelper.findMethod(Ingredient.class, (String)"m_43911_", (Class[])new Class[]{Tag});
            ingredient = (Ingredient)of.invoke(null, tag);
        }
        catch (ObfuscationReflectionHelper.UnableToFindMethodException getAllTags) {
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (ingredient == null) {
            try {
                Method bind = ObfuscationReflectionHelper.findMethod(ItemTags.class, (String)"m_203854_", (Class[])new Class[]{String.class});
                Object tag = bind.invoke(null, name);
                Class<?> TagKey = Class.forName("net.minecraft.tags.TagKey");
                Method of = ObfuscationReflectionHelper.findMethod(Ingredient.class, (String)"m_204132_", (Class[])new Class[]{TagKey});
                ingredient = (Ingredient)of.invoke(null, tag);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ingredient;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ShieldTileEntityRenderer.instance;
            }
        });
    }

    public int getDamageReduction() {
        return this.damageReduction.get();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return ((Ingredient)this.repairMaterial.m_13971_()).test(repair);
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent e) {
        if (((Boolean)Config.enableDamageReduction.get()).booleanValue()) {
            float damage = e.getOriginalBlockedDamage();
            LivingEntity victim = e.getEntityLiving();
            DamageSource source = e.getDamageSource();
            if (source.m_19360_()) {
                return;
            }
            float f1 = 0.0f;
            if (damage > 0.0f && victim.m_21275_(source)) {
                int level;
                f1 = damage;
                float reduction = 1.0f;
                Item shield = victim.m_21211_().m_41720_();
                if (shield instanceof BetterShieldItem) {
                    reduction = (float)((BetterShieldItem)shield).getDamageReduction() / 100.0f;
                } else if (shield == Items.f_42740_ || !((Boolean)Config.customShieldMaxReduction.get()).booleanValue() && victim.m_21211_().m_41780_() == UseAnim.BLOCK) {
                    reduction = (float)((Integer)Config.defaultDamageReduction.get()).intValue() / 100.0f;
                }
                if (reduction < 1.0f) {
                    f1 = damage * reduction;
                }
                if ((level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44972_, (ItemStack)victim.m_21211_())) > 0 && reduction == 1.0f) {
                    Enchantments.f_44972_.m_7675_(victim, source.m_7639_(), level);
                }
            }
            e.setBlockedDamage(f1);
        }
    }
}

