/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.setup.Config;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Tags", description="Set and use some tags to set some mobs properties. E.g. cause fire explosion for mobs or get if a mob has been spawned from spawner.")
public class TagsFeature
extends Feature {
    public TagsFeature(Module module) {
        super(Config.builder, module, true, false);
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        Entity entity = explosion.getExploder();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        CompoundTag compoundNBT = creeper.getPersistentData();
        if (compoundNBT.m_128471_("insanelib:explosion_causes_fire")) {
            explosion.f_46009_ = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawnReason() == MobSpawnType.SPAWNER) {
            event.getEntityLiving().getPersistentData().m_128379_("insanelib:spawned_from_spawner", true);
        }
        if (event.getSpawnReason() == MobSpawnType.STRUCTURE) {
            event.getEntityLiving().getPersistentData().m_128379_("insanelib:spawned_from_structure", true);
        }
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getEntityLiving().getPersistentData().m_128441_("insanelib:xp_multiplier")) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * event.getEntityLiving().getPersistentData().m_128459_("insanelib:xp_multiplier")));
        }
    }
}

