/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.client.render.model.Models;
import com.magistuarmory.init.HeraldryPattern;
import com.magistuarmory.init.ModCreativeTabs;
import com.magistuarmory.item.HeraldryPatternItem;
import com.magistuarmory.item.ItemRegistryHelper;
import com.magistuarmory.item.MedievalBowItem;
import com.magistuarmory.item.MedievalCrossbowItem;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ShieldType;
import com.magistuarmory.item.ShieldTypes;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.item.WeaponTypes;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.ArmorTypes;
import com.magistuarmory.item.armor.MedievalArmorItem;
import com.magistuarmory.item.armor.MedievalHorseArmorItem;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BannerPattern;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"magistuarmory", (ResourceKey)Registry.f_122904_);
    public static final List<RegistrySupplier<MedievalShieldItem>> SHIELD_ITEMS = new ArrayList<RegistrySupplier<MedievalShieldItem>>();
    public static final List<RegistrySupplier<MedievalWeaponItem>> WEAPON_ITEMS = new ArrayList<RegistrySupplier<MedievalWeaponItem>>();
    public static final List<RegistrySupplier<? extends Item>> DYEABLE_ITEMS = new ArrayList<RegistrySupplier<? extends Item>>();
    public static final List<RegistrySupplier<MedievalArmorItem>> ARMOR_ITEMS = new ArrayList<RegistrySupplier<MedievalArmorItem>>();
    public static final List<RegistrySupplier<Item>> INGREDIENT_ITEMS = new ArrayList<RegistrySupplier<Item>>();
    public static final RegistrySupplier<MedievalArmorItem> ARMET = ModItems.addKnightItem("armet", ArmorTypes.ARMET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KNIGHT_CHESTPLATE = ModItems.addMedievalArmorItem("knight_chestplate", ArmorTypes.KNIGHT, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KNIGHT_LEGGINGS = ModItems.addMedievalArmorItem("knight_leggings", ArmorTypes.KNIGHT, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KNIGHT_BOOTS = ModItems.addMedievalArmorItem("knight_boots", ArmorTypes.KNIGHT, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> STECHHELM = ModItems.addJoustingItem("stechhelm", ArmorTypes.STECHHELM, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> JOUSTING_CHESTPLATE = ModItems.addJoustingItem("jousting_chestplate", ArmorTypes.JOUSTING, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> JOUSTING_LEGGINGS = ModItems.addJoustingItem("jousting_leggings", ArmorTypes.JOUSTING, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> JOUSTING_BOOTS = ModItems.addJoustingItem("jousting_boots", ArmorTypes.JOUSTING, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> SALLET = ModItems.addMedievalArmorItem("sallet", ArmorTypes.SALLET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.SALLET);
    public static final RegistrySupplier<MedievalArmorItem> GOTHIC_CHESTPLATE = ModItems.addMedievalArmorItem("gothic_chestplate", ArmorTypes.GOTHIC, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> GOTHIC_LEGGINGS = ModItems.addMedievalArmorItem("gothic_leggings", ArmorTypes.GOTHIC, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> GOTHIC_BOOTS = ModItems.addMedievalArmorItem("gothic_boots", ArmorTypes.GOTHIC, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> MAXIMILIAN_HELMET = ModItems.addMedievalArmorItem("maximilian_helmet", ArmorTypes.MAXIMILIAN_HELMET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.MAXIMILIAN_HELMET);
    public static final RegistrySupplier<MedievalArmorItem> MAXIMILIAN_CHESTPLATE = ModItems.addMedievalArmorItem("maximilian_chestplate", ArmorTypes.MAXIMILIAN, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> MAXIMILIAN_LEGGINGS = ModItems.addMedievalArmorItem("maximilian_leggings", ArmorTypes.MAXIMILIAN, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> MAXIMILIAN_BOOTS = ModItems.addMedievalArmorItem("maximilian_boots", ArmorTypes.MAXIMILIAN, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CHAINMAIL_HELMET = ModItems.addMedievalArmorItem("chainmail_helmet", ArmorTypes.CHAINMAIL, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CHAINMAIL_CHESTPLATE = ModItems.addMedievalArmorItem("chainmail_chestplate", ArmorTypes.CHAINMAIL, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CHAINMAIL_LEGGINGS = ModItems.addMedievalArmorItem("chainmail_leggings", ArmorTypes.CHAINMAIL, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CHAINMAIL_BOOTS = ModItems.addMedievalArmorItem("chainmail_boots", ArmorTypes.CHAINMAIL, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KETTLEHAT = ModItems.addMedievalArmorItem("kettlehat", ArmorTypes.KETTLEHAT, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.KETTLEHAT);
    public static final RegistrySupplier<MedievalArmorItem> PLATEMAIL_CHESTPLATE = ModItems.addMedievalArmorItem("platemail_chestplate", ArmorTypes.PLATEMAIL, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> PLATEMAIL_LEGGINGS = ModItems.addMedievalArmorItem("platemail_leggings", ArmorTypes.PLATEMAIL, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> PLATEMAIL_BOOTS = ModItems.addMedievalArmorItem("platemail_boots", ArmorTypes.PLATEMAIL, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> BARBUTE = ModItems.addMedievalArmorItem("barbute", ArmorTypes.BARBUTE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.BARBUTE);
    public static final RegistrySupplier<MedievalArmorItem> HALFARMOR_CHESTPLATE = ModItems.addMedievalArmorItem("halfarmor_chestplate", ArmorTypes.HALFARMOR, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> GREATHELM = ModItems.addMedievalArmorItem("greathelm", ArmorTypes.CRUSADER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CRUSADER_CHESTPLATE = ModItems.addDyeableMedievalArmorItem("crusader_chestplate", ArmorTypes.CRUSADER, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -3227226);
    public static final RegistrySupplier<MedievalArmorItem> CRUSADER_LEGGINGS = ModItems.addMedievalArmorItem("crusader_leggings", ArmorTypes.CRUSADER, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CRUSADER_BOOTS = ModItems.addDyeableMedievalArmorItem("crusader_boots", ArmorTypes.CRUSADER, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -3227226);
    public static final RegistrySupplier<MedievalArmorItem> CEREMONIAL_ARMET = ModItems.addKnightItem("ceremonialarmet", ArmorTypes.CEREMONIAL_ARMET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CEREMONIAL_CHESTPLATE = ModItems.addMedievalArmorItem("ceremonial_chestplate", ArmorTypes.CEREMONIAL, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CEREMONIAL_BOOTS = ModItems.addMedievalArmorItem("ceremonial_boots", ArmorTypes.CEREMONIAL, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> COIF = ModItems.addDyeableMedievalArmorItem("coif", ArmorTypes.GAMBESON, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -4280691);
    public static final RegistrySupplier<MedievalArmorItem> GAMBESON = ModItems.addDyeableMedievalArmorItem("gambeson_chestplate", ArmorTypes.GAMBESON, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -4280691);
    public static final RegistrySupplier<MedievalArmorItem> PANTYHOSE = ModItems.addDyeableMedievalArmorItem("pantyhose", ArmorTypes.GAMBESON, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -14531028);
    public static final RegistrySupplier<MedievalArmorItem> GAMBESON_BOOTS = ModItems.addDyeableMedievalArmorItem("gambeson_boots", ArmorTypes.GAMBESON, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -4280691);
    public static final RegistrySupplier<MedievalArmorItem> BRIGANDINE = ModItems.addDyeableMedievalArmorItem("brigandine_chestplate", ArmorTypes.BRIGANDINE, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), 10511680);
    public static final RegistrySupplier<MedievalArmorItem> NORMAN_HELMET = ModItems.addMedievalArmorItem("norman_helmet", ArmorTypes.NORMAN, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> SHISHAK = ModItems.addMedievalArmorItem("shishak", ArmorTypes.SHISHAK, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_BARBUTE = ModItems.addMedievalArmorItem("rustedbarbute", ArmorTypes.RUSTED_BARBUTE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED), Models.ArmorEnum.BARBUTE);
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_HALFARMOR_CHESTPLATE = ModItems.addMedievalArmorItem("rustedhalfarmor_chestplate", ArmorTypes.RUSTED_HALFARMOR, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_GREATHELM = ModItems.addMedievalArmorItem("rustedgreathelm", ArmorTypes.RUSTED_CRUSADER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CRUSADER_CHESTPLATE = ModItems.addMedievalArmorItem("rustedcrusader_chestplate", ArmorTypes.RUSTED_CRUSADER, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CRUSADER_BOOTS = ModItems.addMedievalArmorItem("rustedcrusader_boots", ArmorTypes.RUSTED_CRUSADER, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_NORMAN_HELMET = ModItems.addMedievalArmorItem("rustednorman_helmet", ArmorTypes.RUSTED_NORMAN, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CHAINMAIL_HELMET = ModItems.addMedievalArmorItem("rustedchainmail_helmet", ArmorTypes.RUSTED_CHAINMAIL, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CHAINMAIL_CHESTPLATE = ModItems.addMedievalArmorItem("rustedchainmail_chestplate", ArmorTypes.RUSTED_CHAINMAIL, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CHAINMAIL_LEGGINGS = ModItems.addMedievalArmorItem("rustedchainmail_leggings", ArmorTypes.RUSTED_CHAINMAIL, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_CHAINMAIL_BOOTS = ModItems.addMedievalArmorItem("rustedchainmail_boots", ArmorTypes.RUSTED_CHAINMAIL, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED));
    public static final RegistrySupplier<MedievalArmorItem> RUSTED_KETTLEHAT = ModItems.addMedievalArmorItem("rustedkettlehat", ArmorTypes.RUSTED_KETTLEHAT, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.RUSTED), Models.ArmorEnum.KETTLEHAT);
    public static final RegistrySupplier<MedievalArmorItem> BASCINET = ModItems.addMedievalArmorItem("bascinet", ArmorTypes.BASCINET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.BASCINET);
    public static final RegistrySupplier<MedievalArmorItem> XIV_CENTURY_KNIGHT_CHESTPLATE = ModItems.addMedievalArmorItem("xivcenturyknight_chestplate", ArmorTypes.XIV_CENTURY_KNIGHT, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> XIV_CENTURY_KNIGHT_LEGGINGS = ModItems.addMedievalArmorItem("xivcenturyknight_leggings", ArmorTypes.XIV_CENTURY_KNIGHT, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> XIV_CENTURY_KNIGHT_BOOTS = ModItems.addMedievalArmorItem("xivcenturyknight_boots", ArmorTypes.XIV_CENTURY_KNIGHT, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> WINGED_HUSSAR_CHESTPLATE = ModItems.addMedievalArmorItem("wingedhussar_chestplate", ArmorTypes.WINGED_HUSSAR_CHESTPLATE, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.WINGED_HUSSAR_CHESTPLATE);
    public static final RegistrySupplier<MedievalArmorItem> BURGONET = ModItems.addMedievalArmorItem("cuirassier_helmet", ArmorTypes.CUIRASSIER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> CUIRASSIER_CHESTPLATE = ModItems.addDyeableMedievalArmorItem("cuirassier_chestplate", ArmorTypes.CUIRASSIER, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -5465480);
    public static final RegistrySupplier<MedievalArmorItem> CUIRASSIER_LEGGINGS = ModItems.addDyeableMedievalArmorItem("cuirassier_leggings", ArmorTypes.CUIRASSIER, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), -5465480);
    public static final RegistrySupplier<MedievalArmorItem> CUIRASSIER_BOOTS = ModItems.addMedievalArmorItem("cuirassier_boots", ArmorTypes.CUIRASSIER, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> GRAND_BASCINET = ModItems.addMedievalArmorItem("grand_bascinet", ArmorTypes.GRAND_BASCINET, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR), Models.ArmorEnum.GRAND_BASCINET);
    public static final RegistrySupplier<MedievalArmorItem> KASTENBRUST_CHESTPLATE = ModItems.addMedievalArmorItem("kastenbrust_chestplate", ArmorTypes.KASTENBRUST, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KASTENBRUST_LEGGINGS = ModItems.addMedievalArmorItem("kastenbrust_leggings", ArmorTypes.KASTENBRUST, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> KASTENBRUST_BOOTS = ModItems.addMedievalArmorItem("kastenbrust_boots", ArmorTypes.KASTENBRUST, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> FACE_HELMET = ModItems.addMedievalArmorItem("face_helmet", ArmorTypes.LAMELLAR, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> LAMELLAR_CHESTPLATE = ModItems.addMedievalArmorItem("lamellar_chestplate", ArmorTypes.LAMELLAR, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalArmorItem> LAMELLAR_BOOTS = ModItems.addMedievalArmorItem("lamellar_boots", ArmorTypes.LAMELLAR, EquipmentSlot.FEET, new Item.Properties().m_41491_(ModCreativeTabs.ARMOR));
    public static final RegistrySupplier<MedievalHorseArmorItem> BARDING = ITEMS.register("barding", () -> new MedievalHorseArmorItem(12, new ResourceLocation("magistuarmory", "textures/entity/horse/armor/barding.png"), new Item.Properties().m_41487_(1).m_41491_(ModCreativeTabs.ARMOR)));
    public static final RegistrySupplier<MedievalHorseArmorItem> CHAINMAIL_HORSE_ARMOR = ITEMS.register("chainmail_horse_armor", () -> new MedievalHorseArmorItem(6, new ResourceLocation("magistuarmory", "textures/entity/horse/armor/horse_armor_chainmail.png"), new Item.Properties().m_41487_(1).m_41491_(ModCreativeTabs.ARMOR)));
    public static final WeaponsSupply STILETTOS = new WeaponsSupply(WeaponsWorkshop.STILETTO);
    public static final WeaponsSupply SHORT_SWORDS = new WeaponsSupply(WeaponsWorkshop.SHORT_SWORD);
    public static final WeaponsSupply KATZBALGERS = new WeaponsSupply(WeaponsWorkshop.KATZBALGER);
    public static final WeaponsSupply PIKES = new WeaponsSupply(WeaponsWorkshop.PIKE);
    public static final WeaponsSupply RANSEURS = new WeaponsSupply(WeaponsWorkshop.RANSEUR);
    public static final WeaponsSupply AHLSPIESSES = new WeaponsSupply(WeaponsWorkshop.AHLSPIESS);
    public static final WeaponsSupply GIANT_LANCES = new WeaponsSupply(WeaponsWorkshop.GIANT_LANCE);
    public static final WeaponsSupply BASTARD_SWORDS = new WeaponsSupply(WeaponsWorkshop.BASTARD_SWORD);
    public static final WeaponsSupply ESTOCS = new WeaponsSupply(WeaponsWorkshop.ESTOC);
    public static final WeaponsSupply CLAYMORS = new WeaponsSupply(WeaponsWorkshop.CLAYMORE);
    public static final WeaponsSupply ZWEIHANDERS = new WeaponsSupply(WeaponsWorkshop.ZWEIHANDER);
    public static final WeaponsSupply FLAME_BLADED_SWORDS = new WeaponsSupply(WeaponsWorkshop.FlAME_BLADED_SWORD);
    public static final WeaponsSupply LOCHABER_AXES = new WeaponsSupply(WeaponsWorkshop.LOCHABER_AXE);
    public static final WeaponsSupply CONCAVE_EDGED_HALBERDS = new WeaponsSupply(WeaponsWorkshop.CONCAVE_EDGED_HALBERD);
    public static final WeaponsSupply HEAVY_MACES = new WeaponsSupply(WeaponsWorkshop.HEAVY_MACE);
    public static final WeaponsSupply HEAVY_WAR_HAMMERS = new WeaponsSupply(WeaponsWorkshop.HEAVY_WAR_HAMMER);
    public static final WeaponsSupply LUCERNE_HAMMERS = new WeaponsSupply(WeaponsWorkshop.LUCERNE_HAMMER);
    public static final WeaponsSupply MORNINGSTARS = new WeaponsSupply(WeaponsWorkshop.MORNINGSTAR);
    public static final WeaponsSupply FLAILS = new WeaponsSupply(WeaponsWorkshop.FLAIL);
    public static final WeaponsSupply GUISARMES = new WeaponsSupply(WeaponsWorkshop.GUISARME);
    public static final RegistrySupplier<MedievalWeaponItem> BLACKSMITH_HAMMER = ModItems.addMedievalWeaponItem("blacksmith_hammer", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.STEEL, WeaponTypes.BLACKSMITH_HAMMER);
    public static final RegistrySupplier<MedievalWeaponItem> BARBED_CLUB = ModItems.addMedievalWeaponItem("barbedclub", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.IRON, WeaponTypes.BARBED_CLUB);
    public static final RegistrySupplier<MedievalWeaponItem> PITCHFORK = ModItems.addMedievalWeaponItem("pitchfork", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.IRON, WeaponTypes.PITCHFORK);
    public static final RegistrySupplier<MedievalWeaponItem> NOBLE_SWORD = ModItems.addMedievalWeaponItem("noble_sword", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.IRON, WeaponTypes.NOBLE_SWORD);
    public static final RegistrySupplier<MedievalWeaponItem> RUSTED_BASTARD_SWORD = ModItems.addMedievalWeaponItem("rusted_bastardsword", new Item.Properties().m_41491_(ModCreativeTabs.RUSTED), ModItemTier.IRON, WeaponTypes.RUSTED_BASTARD_SWORD);
    public static final RegistrySupplier<MedievalWeaponItem> RUSTED_HEAVY_MACE = ModItems.addMedievalWeaponItem("rusted_heavymace", new Item.Properties().m_41491_(ModCreativeTabs.RUSTED), ModItemTier.IRON, WeaponTypes.RUSTED_HEAVY_MACE);
    public static final RegistrySupplier<MedievalWeaponItem> CLUB = ModItems.addMedievalWeaponItem("club", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.WOOD, WeaponTypes.CLUB);
    public static final RegistrySupplier<MedievalWeaponItem> MESSER_SWORD = ModItems.addMedievalWeaponItem("messer_sword", new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS), ModItemTier.IRON, WeaponTypes.MESSER_SWORD);
    public static final RegistrySupplier<BowItem> LONGBOW = ITEMS.register("longbow", () -> new MedievalBowItem(new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS).m_41487_(1).m_41503_(420), 4.2f, 26.0f));
    public static final RegistrySupplier<CrossbowItem> HEAVY_CROSSBOW = ITEMS.register("heavy_crossbow", () -> new MedievalCrossbowItem(new Item.Properties().m_41491_(ModCreativeTabs.PARTICULAR_WEAPONS).m_41487_(1).m_41503_(500), 4.3f, 50));
    public static final ShieldsSupply HEATER_SHIELDS = new ShieldsSupply(ShieldsWorkshop.HEATER_SHIELD, "heatershield");
    public static final ShieldsSupply TARGETS = new ShieldsSupply(ShieldsWorkshop.TARGET, "target");
    public static final ShieldsSupply BUCKLERS = new ShieldsSupply(ShieldsWorkshop.BUCKLER, "buckler");
    public static final ShieldsSupply RONDACHES = new ShieldsSupply(ShieldsWorkshop.RONDACHE, "rondache");
    public static final ShieldsSupply TARTSCHES = new ShieldsSupply(ShieldsWorkshop.TARTSCHE, "tartsche");
    public static final ShieldsSupply ELLIPTICAL_SHIELDS = new ShieldsSupply(ShieldsWorkshop.ELLIPTICAL_SHIELD, "ellipticalshield");
    public static final ShieldsSupply ROUND_SHIELDS = new ShieldsSupply(ShieldsWorkshop.ROUND_SHIELD, "roundshield");
    public static final ShieldsSupply PAVESES = new ShieldsSupply(ShieldsWorkshop.PAVESE, "pavese");
    public static final ShieldsSupply KITE_SHIELDS = new ShieldsSupply(ShieldsWorkshop.KITE_SHIELD, "kiteshield");
    public static final RegistrySupplier<MedievalShieldItem> CORRUPTED_ROUND_SHIELD = ModItems.addMedievalShieldItem("corruptedroundshield", "corruptedroundshield", new Item.Properties().m_41491_(ModCreativeTabs.RUSTED), ModItemTier.WOOD, false, true, ShieldTypes.CORRUPTED_ROUND_SHIELD, Models.ShieldEnum.CORRUPTED_ROUND_SHIELD);
    public static final RegistrySupplier<Item> APOSTOLIC_CROSS_PATTERN = ITEMS.register("apostolic_cross_pattern", () -> new HeraldryPatternItem(HeraldryPattern.APOSTOLIC_CROSS_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> BOWL_PATTERN = ITEMS.register("bowl_pattern", () -> new HeraldryPatternItem(HeraldryPattern.BOWL_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> BULL_PATTERN = ITEMS.register("bull_pattern", () -> new HeraldryPatternItem(HeraldryPattern.BULL_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> CHESS_PATTERN = ITEMS.register("chess_pattern", () -> new HeraldryPatternItem(HeraldryPattern.CHESS_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> CRUSADER_CROSS_PATTERN = ITEMS.register("crusader_cross_pattern", () -> new HeraldryPatternItem(HeraldryPattern.CRUSADER_CROSS_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> DRAGON_PATTERN = ITEMS.register("dragon_pattern", () -> new HeraldryPatternItem(HeraldryPattern.DRAGON_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> EAGLE_PATTERN = ITEMS.register("eagle_pattern", () -> new HeraldryPatternItem(HeraldryPattern.EAGLE_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> HORSE_PATTERN = ITEMS.register("horse_pattern", () -> new HeraldryPatternItem(HeraldryPattern.HORSE_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> LILY_PATTERN = ITEMS.register("lily_pattern", () -> new HeraldryPatternItem(HeraldryPattern.LILY_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> LION1_PATTERN = ITEMS.register("lion1_pattern", () -> new HeraldryPatternItem(HeraldryPattern.LION1_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> LION2_PATTERN = ITEMS.register("lion2_pattern", () -> new HeraldryPatternItem(HeraldryPattern.LION2_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> ORTHODOX_CROSS_PATTERN = ITEMS.register("orthodox_cross_pattern", () -> new HeraldryPatternItem(HeraldryPattern.ORTHODOX_CROSS_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> SNAKE_PATTERN = ITEMS.register("snake_pattern", () -> new HeraldryPatternItem(HeraldryPattern.SNAKE_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> SUN_PATTERN = ITEMS.register("sun_pattern", () -> new HeraldryPatternItem(HeraldryPattern.SUN_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> SWORDS_PATTERN = ITEMS.register("swords_pattern", () -> new HeraldryPatternItem(HeraldryPattern.SWORDS_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> TOWER_PATTERN = ITEMS.register("tower_pattern", () -> new HeraldryPatternItem(HeraldryPattern.TOWER_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> TREE_PATTERN = ITEMS.register("tree_pattern", () -> new HeraldryPatternItem(HeraldryPattern.TREE_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> TWOHEADED_EAGLE_PATTERN = ITEMS.register("two-headed_eagle_pattern", () -> new HeraldryPatternItem(HeraldryPattern.TWOHEADED_EAGLE_PATTERN, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_INGOT = ModItems.addIngredientItem("steel_ingot", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_NUGGET = ModItems.addIngredientItem("steel_nugget", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_RING = ModItems.addIngredientItem("steel_ring", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_CHAINMAIL = ModItems.addIngredientItem("steel_chainmail", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_PLATE = ModItems.addIngredientItem("steel_plate", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> LEATHER_STRIP = ModItems.addIngredientItem("leather_strip", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> HILT = ModItems.addIngredientItem("hilt", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> POLE = ModItems.addIngredientItem("pole", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> STEEL_CHAIN = ModItems.addIngredientItem("steel_chain", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> WOOLEN_FABRIC = ModItems.addIngredientItem("woolen_fabric", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> SMALL_STEEL_PLATE = ModItems.addIngredientItem("small_steel_plate", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistrySupplier<Item> LAMELLAR_ROWS = ModItems.addIngredientItem("lamellar_rows", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));

    public static RegistrySupplier<MedievalArmorItem> addKnightItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerKnightItem(id, type, slot, properties);
        DYEABLE_ITEMS.add(armor);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalArmorItem> addJoustingItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerJoustingItem(id, type, slot, properties);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalArmorItem> addMedievalArmorItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerMedievalArmorItem(id, type, slot, properties);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalArmorItem> addMedievalArmorItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties, Models.ArmorEnum modelkey) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerMedievalArmorItem(id, type, slot, properties, modelkey);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalArmorItem> addDyeableMedievalArmorItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties, int defaultcolor) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerDyeableMedievalArmorItem(id, type, slot, properties, defaultcolor);
        DYEABLE_ITEMS.add(armor);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalArmorItem> addDyeableMedievalArmorItem(String id, ArmorType type, EquipmentSlot slot, Item.Properties properties, int defaultcolor, Models.ArmorEnum modelkey) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalArmorItem> armor = ItemRegistryHelper.registerDyeableMedievalArmorItem(id, type, slot, properties, defaultcolor, modelkey);
        DYEABLE_ITEMS.add(armor);
        ARMOR_ITEMS.add(armor);
        return armor;
    }

    public static RegistrySupplier<MedievalWeaponItem> addMedievalWeaponItem(String id, Item.Properties properties, ModItemTier material, WeaponType type) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalWeaponItem> weapon = ItemRegistryHelper.registerMedievalWeaponItem(id, properties, material, type);
        WEAPON_ITEMS.add(weapon);
        return weapon;
    }

    public static RegistrySupplier<MedievalWeaponItem> addLanceItem(String id, Item.Properties properties, ModItemTier material, WeaponType type) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalWeaponItem> weapon = ItemRegistryHelper.registerLanceItem(id, properties, material, type);
        WEAPON_ITEMS.add(weapon);
        return weapon;
    }

    public static RegistrySupplier<Item> addIngredientItem(String id, Supplier<Item> supplier) {
        RegistrySupplier registrysupplier = ITEMS.register(id, supplier);
        INGREDIENT_ITEMS.add((RegistrySupplier<Item>)registrysupplier);
        return registrysupplier;
    }

    public static RegistrySupplier<MedievalShieldItem> addMedievalShieldItem(String id, String name, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type, Models.ShieldEnum modelkey) {
        if (type.isDisabled()) {
            return null;
        }
        RegistrySupplier<MedievalShieldItem> shield = ItemRegistryHelper.registerMedievalShieldItem(id, name, properties, material, paintable, is3d, type, modelkey);
        SHIELD_ITEMS.add(shield);
        return shield;
    }

    public static void init() {
        ITEMS.register();
    }

    static {
        if (Platform.isFabric()) {
            ITEMS.register("tin_ingot", () -> new Item(new Item.Properties()));
            ITEMS.register("silver_ingot", () -> new Item(new Item.Properties()));
            ITEMS.register("bronze_ingot", () -> new Item(new Item.Properties()));
        }
    }

    public static class WeaponsSupply
    extends ItemsSupply<MedievalWeaponItem> {
        public WeaponsSupply(BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> workshop) {
            super(workshop, new Item.Properties().m_41491_(ModCreativeTabs.WEAPONS));
        }
    }

    static class WeaponsWorkshop {
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> STILETTO = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_stylet", prop, material, WeaponTypes.STILETTO);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> SHORT_SWORD = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_shortsword", prop, material, WeaponTypes.SHORT_SWORD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> KATZBALGER = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_katzbalger", prop, material, WeaponTypes.KATZBALGER);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> PIKE = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_pike", prop, material, WeaponTypes.PIKE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> RANSEUR = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_ranseur", prop, material, WeaponTypes.RANSEUR);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> AHLSPIESS = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_ahlspiess", prop, material, WeaponTypes.AHLSPIESS);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> GIANT_LANCE = (material, prop) -> ModItems.addLanceItem(material.getMaterialName() + "_chivalrylance", prop, material, WeaponTypes.GIANT_LANCE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> BASTARD_SWORD = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_bastardsword", prop, material, WeaponTypes.BASTARD_SWORD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> ESTOC = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_estoc", prop, material, WeaponTypes.ESTOC);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> CLAYMORE = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_claymore", prop, material, WeaponTypes.CLAYMORE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> ZWEIHANDER = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_zweihander", prop, material, WeaponTypes.ZWEIHANDER);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> FlAME_BLADED_SWORD = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_flamebladedsword", prop, material, WeaponTypes.FlAME_BLADED_SWORD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> LOCHABER_AXE = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_lochaberaxe", prop, material, WeaponTypes.LOCHABER_AXE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> CONCAVE_EDGED_HALBERD = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_concavehalberd", prop, material, WeaponTypes.CONCAVE_EDGED_HALBERD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> HEAVY_MACE = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_heavymace", prop, material, WeaponTypes.HEAVY_MACE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> HEAVY_WAR_HAMMER = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_heavywarhammer", prop, material, WeaponTypes.HEAVY_WAR_HAMMER);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> LUCERNE_HAMMER = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_lucernhammer", prop, material, WeaponTypes.LUCERNE_HAMMER);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> MORNINGSTAR = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_morgenstern", prop, material, WeaponTypes.MORNINGSTAR);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> FLAIL = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_chainmorgenstern", prop, material, WeaponTypes.FLAIL);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalWeaponItem>> GUISARME = (material, prop) -> ModItems.addMedievalWeaponItem(material.getMaterialName() + "_guisarme", prop, material, WeaponTypes.GUISARME);

        WeaponsWorkshop() {
        }
    }

    public static class ShieldsSupply
    extends ItemsSupply<MedievalShieldItem> {
        public String shieldName;
        public String woodTexture;
        public String stoneTexture;
        public String ironTexture;
        public String goldTexture;
        public String diamondTexture;
        public String netheriteTexture;
        public String copperTexture;
        public String steelTexture;
        public String silverTexture;
        public String tinTexture;
        public String bronzeTexture;

        public ShieldsSupply(BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> workshop, String shieldName) {
            super(workshop, new Item.Properties().m_41491_(ModCreativeTabs.SHIELDS));
            this.shieldName = shieldName;
            this.woodTexture = "entity/" + ModItemTier.WOOD.getMaterialName() + "_" + shieldName;
            this.stoneTexture = "entity/" + ModItemTier.STONE.getMaterialName() + "_" + shieldName;
            this.ironTexture = "entity/" + ModItemTier.IRON.getMaterialName() + "_" + shieldName;
            this.goldTexture = "entity/" + ModItemTier.GOLD.getMaterialName() + "_" + shieldName;
            this.diamondTexture = "entity/" + ModItemTier.DIAMOND.getMaterialName() + "_" + shieldName;
            this.copperTexture = "entity/" + ModItemTier.COPPER.getMaterialName() + "_" + shieldName;
            this.steelTexture = "entity/" + ModItemTier.STEEL.getMaterialName() + "_" + shieldName;
            this.silverTexture = "entity/" + ModItemTier.SILVER.getMaterialName() + "_" + shieldName;
            this.netheriteTexture = "entity/" + ModItemTier.NETHERITE.getMaterialName() + "_" + shieldName;
            this.tinTexture = "entity/" + ModItemTier.TIN.getMaterialName() + "_" + shieldName;
            this.bronzeTexture = "entity/" + ModItemTier.BRONZE.getMaterialName() + "_" + shieldName;
        }

        public void stitchWithoutPatterns(TextureAtlas atlas, Consumer<ResourceLocation> adder) {
            if (atlas.m_118330_() == TextureAtlas.f_118259_) {
                String[] textures;
                for (String texture : textures = new String[]{this.woodTexture, this.stoneTexture, this.ironTexture, this.goldTexture, this.diamondTexture, this.netheriteTexture, this.copperTexture, this.steelTexture, this.silverTexture, this.netheriteTexture, this.tinTexture, this.bronzeTexture}) {
                    adder.accept(new ResourceLocation("magistuarmory", texture + "_nopattern"));
                }
            }
        }

        public void stitch(TextureAtlas atlas, Consumer<ResourceLocation> adder) {
            if (atlas.m_118330_() == TextureAtlas.f_118259_) {
                String[] textures;
                String[] stringArray = textures = new String[]{this.woodTexture, this.stoneTexture, this.ironTexture, this.goldTexture, this.diamondTexture, this.netheriteTexture, this.copperTexture, this.steelTexture, this.silverTexture, this.netheriteTexture, this.tinTexture, this.bronzeTexture};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String texture = stringArray[i];
                    ResourceLocation location1 = new ResourceLocation("magistuarmory", texture + "_pattern");
                    adder.accept(location1);
                    ResourceLocation location2 = new ResourceLocation("magistuarmory", texture + "_nopattern");
                    adder.accept(location2);
                }
            }
            if (atlas.m_118330_() == Sheets.f_110738_) {
                for (BannerPattern bannerPattern : BannerPattern.values()) {
                    String filename = bannerPattern.m_58572_();
                    if (filename.contains(":")) {
                        filename = filename.split(":")[1];
                    }
                    ResourceLocation location = new ResourceLocation("magistuarmory", "entity/" + this.shieldName + "/" + filename);
                    adder.accept(location);
                }
            }
        }
    }

    static class ShieldsWorkshop {
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> HEATER_SHIELD = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_heatershield", "heatershield", prop, material, true, true, ShieldTypes.HEATER_SHIELD, Models.ShieldEnum.HEATER_SHIELD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> TARGET = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_target", "target", prop, material, false, true, ShieldTypes.TARGET, Models.ShieldEnum.TARGET);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> BUCKLER = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_buckler", "buckler", prop, material, false, true, ShieldTypes.BUCKLER, Models.ShieldEnum.BUCKLER);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> RONDACHE = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_rondache", "rondache", prop, material, false, true, ShieldTypes.RONDACHE, Models.ShieldEnum.RONDACHE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> TARTSCHE = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_tartsche", "tartsche", prop, material, true, true, ShieldTypes.TARTSCHE, Models.ShieldEnum.TARTSCHE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> ELLIPTICAL_SHIELD = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_ellipticalshield", "ellipticalshield", prop, material, true, true, ShieldTypes.ELLIPTICAL_SHIELD, Models.ShieldEnum.ELLIPTICAL_SHIELD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> ROUND_SHIELD = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_roundshield", "roundshield", prop, material, true, true, ShieldTypes.ROUND_SHIELD, Models.ShieldEnum.ROUND_SHIELD);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> PAVESE = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_pavese", "pavese", prop, material, true, true, ShieldTypes.PAVESE, Models.ShieldEnum.PAVESE);
        public static final BiFunction<ModItemTier, Item.Properties, RegistrySupplier<MedievalShieldItem>> KITE_SHIELD = (material, prop) -> ModItems.addMedievalShieldItem(material.getMaterialName() + "_kiteshield", "kiteshield", prop, material, true, true, ShieldTypes.KITE_SHIELD, Models.ShieldEnum.KITE_SHIELD);

        ShieldsWorkshop() {
        }
    }

    public static class ItemsSupply<T extends Item> {
        public RegistrySupplier<T> wood;
        public RegistrySupplier<T> stone;
        public RegistrySupplier<T> iron;
        public RegistrySupplier<T> gold;
        public RegistrySupplier<T> diamond;
        public RegistrySupplier<T> copper;
        public RegistrySupplier<T> steel;
        public RegistrySupplier<T> silver;
        public RegistrySupplier<T> netherite;
        public RegistrySupplier<T> tin;
        public RegistrySupplier<T> bronze;

        public ItemsSupply(BiFunction<ModItemTier, Item.Properties, RegistrySupplier<T>> workshop, Item.Properties prop) {
            this.wood = workshop.apply(ModItemTier.WOOD, prop);
            this.stone = workshop.apply(ModItemTier.STONE, prop);
            this.iron = workshop.apply(ModItemTier.IRON, prop);
            this.gold = workshop.apply(ModItemTier.GOLD, prop);
            this.diamond = workshop.apply(ModItemTier.DIAMOND, prop);
            this.netherite = workshop.apply(ModItemTier.NETHERITE, prop.m_41486_());
            this.copper = workshop.apply(ModItemTier.COPPER, prop);
            this.steel = workshop.apply(ModItemTier.STEEL, prop);
            this.silver = workshop.apply(ModItemTier.SILVER, prop);
            this.tin = workshop.apply(ModItemTier.TIN, prop);
            this.bronze = workshop.apply(ModItemTier.BRONZE, prop);
        }

        public ArrayList<RegistrySupplier<T>> get() {
            ArrayList<RegistrySupplier<T>> suppliers = new ArrayList<RegistrySupplier<T>>();
            suppliers.add(this.wood);
            suppliers.add(this.stone);
            suppliers.add(this.iron);
            suppliers.add(this.gold);
            suppliers.add(this.diamond);
            suppliers.add(this.copper);
            suppliers.add(this.steel);
            suppliers.add(this.silver);
            suppliers.add(this.netherite);
            suppliers.add(this.tin);
            suppliers.add(this.bronze);
            return suppliers;
        }
    }
}

