/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.item.IHasModelProperty;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MedievalCrossbowItem
extends CrossbowItem
implements IHasModelProperty {
    private final int pullTime;
    private final float projectileSpeed;
    protected boolean startSoundPlayed = false;
    protected boolean midLoadSoundPlayed = false;

    public MedievalCrossbowItem(Item.Properties properties, float projectileSpeed, int pullTime) {
        super(properties);
        this.projectileSpeed = projectileSpeed;
        this.pullTime = pullTime;
    }

    public void m_5929_(Level p_40910_, LivingEntity p_40911_, ItemStack p_40912_, int p_40913_) {
        if (!p_40910_.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)p_40912_);
            SoundEvent soundevent = this.getStartSound(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(p_40912_.m_41779_() - p_40913_) / (float)this.getPullTime(p_40912_);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                p_40910_.m_6263_((Player)null, p_40911_.m_20185_(), p_40911_.m_20186_(), p_40911_.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                p_40910_.m_6263_((Player)null, p_40911_.m_20185_(), p_40911_.m_20186_(), p_40911_.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack p_40875_, Level p_40876_, LivingEntity p_40877_, int p_40878_) {
        int i = this.m_8105_(p_40875_) - p_40878_;
        float f = this.getPower(i, p_40875_);
        if (f >= 1.0f && !MedievalCrossbowItem.m_40932_((ItemStack)p_40875_) && MedievalCrossbowItem.tryLoadProjectiles(p_40877_, p_40875_)) {
            MedievalCrossbowItem.m_40884_((ItemStack)p_40875_, (boolean)true);
            SoundSource soundsource = p_40877_ instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            p_40876_.m_6263_((Player)null, p_40877_.m_20185_(), p_40877_.m_20186_(), p_40877_.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (p_40876_.m_5822_().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity p_40860_, ItemStack p_40861_) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)p_40861_);
        int j = i == 0 ? 1 : 3;
        boolean flag = p_40860_ instanceof Player && ((Player)p_40860_).m_150110_().f_35937_;
        ItemStack itemstack = p_40860_.m_6298_(p_40861_);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (MedievalCrossbowItem.loadProjectile(p_40860_, p_40861_, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity p_40863_, ItemStack p_40864_, ItemStack p_40865_, boolean p_40866_, boolean p_40867_) {
        ItemStack itemstack;
        boolean flag;
        if (p_40865_.m_41619_()) {
            return false;
        }
        boolean bl = flag = p_40867_ && p_40865_.m_41720_() instanceof ArrowItem;
        if (!(flag || p_40867_ || p_40866_)) {
            itemstack = p_40865_.m_41620_(1);
            if (p_40865_.m_41619_() && p_40863_ instanceof Player) {
                ((Player)p_40863_).m_150109_().m_36057_(p_40865_);
            }
        } else {
            itemstack = p_40865_.m_41777_();
        }
        MedievalCrossbowItem.addChargedProjectile(p_40864_, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack p_40929_, ItemStack p_40930_) {
        CompoundTag compoundtag = p_40929_.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        p_40930_.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40920_, Player p_40921_, InteractionHand p_40922_) {
        ItemStack itemstack = p_40921_.m_21120_(p_40922_);
        if (MedievalCrossbowItem.m_40932_((ItemStack)itemstack)) {
            MedievalCrossbowItem.m_40887_((Level)p_40920_, (LivingEntity)p_40921_, (InteractionHand)p_40922_, (ItemStack)itemstack, (float)this.getProjectileSpeed(itemstack), (float)1.0f);
            MedievalCrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!p_40921_.m_6298_(itemstack).m_41619_()) {
            if (!MedievalCrossbowItem.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                p_40921_.m_6672_(p_40922_);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private SoundEvent getStartSound(int p_40852_) {
        switch (p_40852_) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    public int getPullTime(ItemStack p_40940_) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)p_40940_);
        return i == 0 ? this.pullTime : this.pullTime - 5 * i;
    }

    public float getProjectileSpeed(ItemStack p_40946_) {
        return MedievalCrossbowItem.m_40871_((ItemStack)p_40946_, (Item)Items.f_42688_) ? 1.6f : this.projectileSpeed;
    }

    private float getPower(int p_40854_, ItemStack p_40855_) {
        float f = (float)p_40854_ / (float)this.getPullTime(p_40855_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack p_40938_) {
        return this.getPullTime(p_40938_) + 3;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return CrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / (float)this.getPullTime(stack);
        });
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("pulling"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("charged"), (stack, level, entity, i) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("firework"), (stack, level, entity, i) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }
}

